/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb.feature;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.dynamodb.feature.DynamoDbFeature;
import org.ff4j.mapper.FeatureMapper;
import org.ff4j.property.Property;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.utils.json.PropertyJsonParser;
import software.amazon.awssdk.utils.CollectionUtils;

public class FeatureDynamoDBMapper
implements FeatureMapper<DynamoDbFeature> {
    public DynamoDbFeature toStore(Feature feature) {
        DynamoDbFeature item = new DynamoDbFeature();
        item.setFeatureUid(feature.getUid());
        item.setEnable(feature.isEnable());
        item.setDescription(feature.getDescription());
        item.setGroupName(feature.getGroup());
        if (feature.getFlippingStrategy() != null) {
            item.setFlippingStrategy(JsonUtils.flippingStrategyAsJson((FlippingStrategy)feature.getFlippingStrategy()));
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)feature.getPermissions())) {
            item.setPermissions(feature.getPermissions());
        }
        if (feature.getCustomProperties() != null && !CollectionUtils.isNullOrEmpty(feature.getCustomProperties().entrySet())) {
            HashMap<String, String> mapOfProperties = new HashMap<String, String>();
            for (Map.Entry customP : feature.getCustomProperties().entrySet()) {
                if (customP.getValue() == null) continue;
                mapOfProperties.put((String)customP.getKey(), ((Property)customP.getValue()).toJson());
            }
            item.setProperties(mapOfProperties);
        }
        return item;
    }

    public Feature fromStore(DynamoDbFeature item) {
        HashSet perms;
        Feature feature = new Feature(item.getFeatureUid());
        feature.setEnable(item.isEnable());
        feature.setDescription(item.getDescription());
        feature.setGroup(item.getGroupName());
        String jsonFlippingStrategy = item.getFlippingStrategy();
        if (Util.hasLength((String)jsonFlippingStrategy)) {
            feature.setFlippingStrategy(FeatureJsonParser.parseFlipStrategyAsJson((String)feature.getUid(), (String)jsonFlippingStrategy));
        }
        feature.setPermissions((Set)((perms = item.getPermissions()) == null ? new HashSet() : perms));
        Map<String, String> props = item.getProperties();
        if (props != null) {
            HashMap<String, Property> customProperties = new HashMap<String, Property>();
            for (Map.Entry<String, String> propString : props.entrySet()) {
                customProperties.put(propString.getKey(), PropertyJsonParser.parseProperty((String)propString.getValue()));
            }
            feature.setCustomProperties(customProperties);
        }
        return feature;
    }
}

