/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb.feature;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.ff4j.core.Feature;
import org.ff4j.dynamodb.DynamoDBClient;
import org.ff4j.dynamodb.feature.DynamoDbFeature;
import org.ff4j.dynamodb.feature.FeatureDynamoDBMapper;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.Page;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.WriteBatch;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.utils.CollectionUtils;

public class FeatureDynamoDBClient
extends DynamoDBClient<Feature, DynamoDbFeature> {
    private final FeatureDynamoDBMapper FEATURE_MAPPER = new FeatureDynamoDBMapper();

    FeatureDynamoDBClient(DynamoDbClient client) {
        super(client);
        this.key = "featureUid";
    }

    @Override
    protected RuntimeException notFoundException(String id) {
        return new FeatureNotFoundException(id);
    }

    @Override
    protected void put(Feature feature) {
        this.table.putItem((Object)this.FEATURE_MAPPER.toStore(feature));
    }

    @Override
    protected Feature get(String featureUid) {
        DynamoDbFeature item = (DynamoDbFeature)this.getItem(featureUid);
        return this.FEATURE_MAPPER.fromStore(item);
    }

    @Override
    protected Map<String, Feature> getAll() {
        PageIterable pages = this.table.scan();
        HashMap<String, Feature> map = new HashMap<String, Feature>();
        pages.items().forEach(dynamoDbFeature -> map.put(dynamoDbFeature.getFeatureUid(), this.FEATURE_MAPPER.fromStore((DynamoDbFeature)dynamoDbFeature)));
        return map;
    }

    Set<String> getAllGroups() {
        SdkIterable pages = this.table.index("ff4j-feature-groups").scan(builder -> builder.attributesToProject(new String[]{"groupName"}));
        HashSet<String> groupNames = new HashSet<String>();
        pages.forEach(p -> p.items().forEach(f -> groupNames.add(f.getGroupName())));
        return groupNames;
    }

    Map<String, Feature> getFeaturesByGroup(String group) {
        SdkIterable<Page<DynamoDbFeature>> items = this.getItemsByGroup(group);
        HashMap<String, Feature> map = new HashMap<String, Feature>();
        items.forEach(dynamoDbFeaturePage -> dynamoDbFeaturePage.items().forEach(dynamoDbFeature -> map.put(dynamoDbFeature.getFeatureUid(), this.FEATURE_MAPPER.fromStore((DynamoDbFeature)dynamoDbFeature))));
        return map;
    }

    SdkIterable<Page<DynamoDbFeature>> getItemsByGroup(String group) {
        SdkIterable pages = this.table.index("ff4j-feature-groups").query(r -> r.queryConditional(QueryConditional.keyEqualTo(k -> k.partitionValue(group))));
        if (pages == null || pages.stream().count() == 0L || pages.stream().allMatch(p -> p.items().size() == 0)) {
            throw new GroupNotFoundException(group);
        }
        return pages;
    }

    void updateFeatureAvailability(String featUid, boolean enable) {
        DynamoDbFeature item = (DynamoDbFeature)this.getItem(featUid);
        if (item.isEnable() == enable) {
            return;
        }
        item.setEnable(enable);
        this.table.updateItem((Object)item);
    }

    void updateFeatureAvailabilityInGroup(String group, boolean enable) {
        SdkIterable<Page<DynamoDbFeature>> itemsByGroup = this.getItemsByGroup(group);
        itemsByGroup.forEach(dynamoDbFeaturePage -> dynamoDbFeaturePage.items().forEach(dynamoDbFeature -> {
            if (dynamoDbFeature.isEnable() != enable) {
                dynamoDbFeature.setEnable(enable);
                this.table.updateItem(dynamoDbFeature);
            }
        }));
    }

    void addFeaturePermission(String featUid, String roleName) {
        DynamoDbFeature item = (DynamoDbFeature)this.getItem(featUid);
        if (item.getPermissions() == null) {
            item.setPermissions(new HashSet<String>());
        }
        item.getPermissions().add(roleName);
        this.table.updateItem((Object)item);
    }

    void removeFeaturePermission(String featUid, String roleName) {
        DynamoDbFeature item = (DynamoDbFeature)this.getItem(featUid);
        if (!CollectionUtils.isNullOrEmpty(item.getPermissions())) {
            item.getPermissions().remove(roleName);
            if (item.getPermissions().size() == 0) {
                item.setPermissions(null);
            }
        }
        this.table.updateItem((Object)item);
    }

    void addToGroup(String featUid, String group) {
        DynamoDbFeature item = (DynamoDbFeature)this.getItem(featUid);
        item.setGroupName(group);
        this.table.updateItem((Object)item);
    }

    void removeFromGroup(String featUid) {
        DynamoDbFeature item = (DynamoDbFeature)this.getItem(featUid);
        item.setGroupName(null);
        this.table.updateItem((Object)item);
    }

    @Override
    protected void loadProperties(Properties prop) {
        this.tableName = prop.getProperty("ff4j.store.dynamodb.feature.table.name", "ff4j-features");
        String billing = prop.getProperty("ff4j.store.dynamodb.feature.table.billing", BillingMode.PROVISIONED.toString());
        this.billingMode = BillingMode.valueOf((String)billing);
        String rcu = prop.getProperty("ff4j.store.dynamodb.feature.table.billing.rcu", String.valueOf(5L));
        this.billingRCU = Long.valueOf(rcu);
        String wcu = prop.getProperty("ff4j.store.dynamodb.feature.table.billing.wcu", String.valueOf(5L));
        this.billingWCU = Long.valueOf(wcu);
    }

    @Override
    protected void createTable() {
        GlobalSecondaryIndex.Builder globalSecondaryIndexBuilder = GlobalSecondaryIndex.builder().indexName("ff4j-feature-groups").keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("groupName").keyType(KeyType.HASH).build()}).projection((Projection)Projection.builder().projectionType(ProjectionType.ALL).build());
        if (BillingMode.PROVISIONED.equals((Object)this.billingMode)) {
            globalSecondaryIndexBuilder.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.billingRCU).writeCapacityUnits(this.billingWCU).build());
        }
        CreateTableRequest.Builder requestBuilder = CreateTableRequest.builder().attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("featureUid").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("groupName").attributeType(ScalarAttributeType.S).build()}).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("featureUid").keyType(KeyType.HASH).build()}).globalSecondaryIndexes(new GlobalSecondaryIndex[]{(GlobalSecondaryIndex)globalSecondaryIndexBuilder.build()}).tableName(this.tableName);
        requestBuilder.billingMode(this.billingMode);
        if (BillingMode.PROVISIONED.equals((Object)this.billingMode)) {
            requestBuilder.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.billingRCU).writeCapacityUnits(this.billingWCU).build());
        }
        try {
            this.client.createTable((CreateTableRequest)requestBuilder.build());
            this.client.waiter().waitUntilTableExists(builder -> builder.tableName(this.tableName));
            this.table = this.dynamoDB.table(this.tableName, TableSchema.fromClass(DynamoDbFeature.class));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize Feature Table in DynamoDB", e);
        }
    }

    void clearTable() {
        PageIterable scan = this.table.scan();
        if (scan != null && scan.iterator().hasNext()) {
            WriteBatch.Builder builder = WriteBatch.builder(DynamoDbFeature.class).mappedTableResource((MappedTableResource)this.table);
            AtomicInteger count = new AtomicInteger();
            scan.forEach(dynamoDbFeaturePage -> dynamoDbFeaturePage.items().forEach(dynamoDbFeature -> {
                builder.addDeleteItem(Key.builder().partitionValue(dynamoDbFeature.getFeatureUid()).build());
                count.getAndIncrement();
            }));
            if (count.intValue() > 0) {
                this.dynamoDB.batchWriteItem(r -> r.writeBatches(new WriteBatch[]{builder.build()}));
            }
        }
    }
}

