/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services.validator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.ff4j.FF4j;
import org.ff4j.services.exceptions.PropertyNameBlankException;
import org.ff4j.services.exceptions.PropertyNameNotMatchException;
import org.ff4j.services.exceptions.PropertyNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/ff4j/services/validator/PropertyValidator;", "", "()V", "ff4j", "Lorg/ff4j/FF4j;", "getFf4j", "()Lorg/ff4j/FF4j;", "setFf4j", "(Lorg/ff4j/FF4j;)V", "assertPropertyExist", "", "propertyName", "", "assertPropertyNameMatch", "propertyApiBeanName", "assertPropertyNameNotBlank", "name", "ff4j-spring-services"})
public class PropertyValidator {
    @Autowired
    public FF4j ff4j;

    @NotNull
    public FF4j getFf4j() {
        FF4j fF4j = this.ff4j;
        if (fF4j != null) {
            return fF4j;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"ff4j");
        return null;
    }

    public void setFf4j(@NotNull FF4j fF4j) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"<set-?>");
        this.ff4j = fF4j;
    }

    public void assertPropertyExist(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (!this.getFf4j().getPropertiesStore().existProperty(propertyName)) {
            throw new PropertyNotFoundException();
        }
    }

    public void assertPropertyNameNotBlank(@Nullable String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new PropertyNameBlankException();
        }
    }

    public void assertPropertyNameMatch(@NotNull String propertyName, @Nullable String propertyApiBeanName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (!StringsKt.equals((String)propertyName, (String)propertyApiBeanName, (boolean)true)) {
            throw new PropertyNameNotMatchException();
        }
    }
}

