/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ff4j.FF4j;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.security.AuthorizationsManager;
import org.ff4j.services.domain.AuthorizationsManagerApiBean;
import org.ff4j.services.domain.FF4jStatusApiBean;
import org.ff4j.services.exceptions.AuthorizationNotExistsException;
import org.ff4j.services.validator.FeatureValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/ff4j/services/FF4jServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "ff4jValidator", "Lorg/ff4j/services/validator/FeatureValidator;", "(Lorg/ff4j/FF4j;Lorg/ff4j/services/validator/FeatureValidator;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "getFf4jValidator", "()Lorg/ff4j/services/validator/FeatureValidator;", "check", "Lreactor/core/publisher/Mono;", "", "featureUID", "", "params", "", "getSecurityInfo", "Lorg/ff4j/services/domain/AuthorizationsManagerApiBean;", "getStatus", "Lorg/ff4j/services/domain/FF4jStatusApiBean;", "ff4j-spring-services"})
@SourceDebugExtension(value={"SMAP\nFF4jServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FF4jServices.kt\norg/ff4j/services/FF4jServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1855#2,2:63\n*S KotlinDebug\n*F\n+ 1 FF4jServices.kt\norg/ff4j/services/FF4jServices\n*L\n58#1:63,2\n*E\n"})
public class FF4jServices {
    @NotNull
    private final FF4j fF4j;
    @NotNull
    private final FeatureValidator ff4jValidator;

    public FF4jServices(@Autowired @NotNull FF4j fF4j, @Autowired @NotNull FeatureValidator ff4jValidator) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"fF4j");
        Intrinsics.checkNotNullParameter((Object)ff4jValidator, (String)"ff4jValidator");
        this.fF4j = fF4j;
        this.ff4jValidator = ff4jValidator;
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public FeatureValidator getFf4jValidator() {
        return this.ff4jValidator;
    }

    @NotNull
    public Mono<FF4jStatusApiBean> getStatus() {
        Mono mono = Mono.just((Object)new FF4jStatusApiBean(this.getFF4j()));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    @NotNull
    public Mono<AuthorizationsManagerApiBean> getSecurityInfo() {
        AuthorizationsManager authorizationsManager = this.getFF4j().getAuthorizationsManager();
        if (authorizationsManager == null) {
            FF4jServices $this$getSecurityInfo_u24lambda_u241 = this;
            boolean bl = false;
            throw new AuthorizationNotExistsException();
        }
        AuthorizationsManager it = authorizationsManager;
        boolean bl = false;
        Mono mono = Mono.just((Object)new AuthorizationsManagerApiBean(it));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    @NotNull
    public Mono<Boolean> check(@NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFf4jValidator().assertFeatureExists(featureUID);
        Mono mono = Mono.just((Object)this.getFF4j().check(featureUID));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    @NotNull
    public Mono<Boolean> check(@NotNull String featureUID, @NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.getFf4jValidator().assertFeatureExists(featureUID);
        FlippingExecutionContext flipExecCtx = new FlippingExecutionContext();
        Iterable $this$forEach$iv = params.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            flipExecCtx.putString((String)it.getKey(), (String)it.getValue());
        }
        Mono mono = Mono.just((Object)this.getFF4j().check(featureUID, flipExecCtx));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }
}

