/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.services.GroupServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.validator.FeatureValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/ff4j/services/GroupServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "ff4jValidator", "Lorg/ff4j/services/validator/FeatureValidator;", "(Lorg/ff4j/FF4j;Lorg/ff4j/services/validator/FeatureValidator;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "getFf4jValidator", "()Lorg/ff4j/services/validator/FeatureValidator;", "disableGroup", "", "groupName", "", "enableGroup", "getFeaturesByGroup", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "ff4j-spring-services"})
public class GroupServices {
    @NotNull
    private final FF4j fF4j;
    @NotNull
    private final FeatureValidator ff4jValidator;

    @NotNull
    public Collection<FeatureApiBean> getFeaturesByGroup(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        this.getFf4jValidator().assertGroupExist(groupName);
        List list = this.getFF4j().getFeatureStore().readGroup(groupName).values().stream().map(getFeaturesByGroup.1.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"fF4j.featureStore.readGr\u2026lect(Collectors.toList())");
        return list;
    }

    public void enableGroup(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        this.getFf4jValidator().assertGroupExist(groupName);
        this.getFF4j().getFeatureStore().enableGroup(groupName);
    }

    public void disableGroup(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        this.getFf4jValidator().assertGroupExist(groupName);
        this.getFF4j().getFeatureStore().disableGroup(groupName);
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public FeatureValidator getFf4jValidator() {
        return this.ff4jValidator;
    }

    public GroupServices(@Autowired @NotNull FF4j fF4j, @Autowired @NotNull FeatureValidator ff4jValidator) {
        Intrinsics.checkParameterIsNotNull((Object)fF4j, (String)"fF4j");
        Intrinsics.checkParameterIsNotNull((Object)ff4jValidator, (String)"ff4jValidator");
        this.fF4j = fF4j;
        this.ff4jValidator = ff4jValidator;
    }
}

