/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.services.FeatureStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.ff4j.services.exceptions.FeatureStoreNotCached;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J>\u0010\u0014\u001a\u00020\b2\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f`\u00182\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/ff4j/services/FeatureStoreServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "(Lorg/ff4j/FF4j;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "clearCachedFeatureStore", "", "deleteAllFeatures", "getAllFeatures", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "getAllGroups", "", "Lorg/ff4j/services/domain/GroupDescApiBean;", "getFeatureStore", "Lorg/ff4j/services/domain/FeatureStoreApiBean;", "getFeaturesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "initGroup", "groups", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "uid", "groupName", "ff4j-spring-services"})
public class FeatureStoreServices {
    @NotNull
    private final FF4j fF4j;

    @NotNull
    public FeatureStoreApiBean getFeatureStore() {
        FeatureStore featureStore = this.getFF4j().getFeatureStore();
        Intrinsics.checkExpressionValueIsNotNull((Object)featureStore, (String)"this.fF4j.featureStore");
        return new FeatureStoreApiBean(featureStore);
    }

    @NotNull
    public Collection<FeatureApiBean> getAllFeatures() {
        Collection collection;
        Map allFeatures = this.getFF4j().getFeatureStore().readAll();
        if (CollectionUtils.isEmpty((Map)allFeatures)) {
            collection = new ArrayList(0);
        } else {
            ArrayList features = new ArrayList(allFeatures.size());
            features.addAll(allFeatures.values().stream().map(getAllFeatures.1.INSTANCE).collect(Collectors.toList()));
            collection = features;
        }
        return collection;
    }

    @NotNull
    public Collection<GroupDescApiBean> getAllGroups() {
        Map allFeatures;
        HashMap<String, GroupDescApiBean> groups = new HashMap<String, GroupDescApiBean>();
        Map map = allFeatures = this.getFF4j().getFeatureStore().readAll();
        if (map != null) {
            Map map2;
            Map it = map2 = map;
            boolean bl = false;
            Iterable $receiver$iv = allFeatures.values();
            for (Object element$iv : $receiver$iv) {
                Feature it2 = (Feature)element$iv;
                boolean bl2 = false;
                Feature feature = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)feature, (String)"it");
                String string = feature.getUid();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.uid");
                this.initGroup(groups, string, it2.getGroup());
            }
        }
        Collection<GroupDescApiBean> collection = groups.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"groups.values");
        return collection;
    }

    private void initGroup(HashMap<String, GroupDescApiBean> groups, String uid, String groupName) {
        block3: {
            String string;
            String string2 = groupName;
            if (string2 == null) break block3;
            String it = string = string2;
            boolean bl = false;
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                Object object;
                if (!groups.containsKey(groupName)) {
                    Map map = groups;
                    String string3 = groupName;
                    GroupDescApiBean groupDescApiBean = new GroupDescApiBean(groupName, new ArrayList());
                    map.put(string3, groupDescApiBean);
                }
                if ((object = groups.get(groupName)) != null && (object = ((GroupDescApiBean)object).getFeatures()) != null) {
                    object.add(uid);
                }
            }
        }
    }

    public void deleteAllFeatures() {
        this.getFF4j().getFeatureStore().clear();
    }

    @NotNull
    public CacheApiBean getFeaturesFromCache() {
        if (this.getFF4j().getCacheProxy() == null) {
            throw (Throwable)new FeatureStoreNotCached();
        }
        FeatureStore featureStore = this.getFF4j().getFeatureStore();
        Intrinsics.checkExpressionValueIsNotNull((Object)featureStore, (String)"fF4j.featureStore");
        return new CacheApiBean(featureStore);
    }

    public void clearCachedFeatureStore() {
        FF4jCacheProxy fF4jCacheProxy = this.getFF4j().getCacheProxy();
        if (fF4jCacheProxy == null) {
            throw (Throwable)new FeatureStoreNotCached();
        }
        FF4jCacheProxy cacheProxy = fF4jCacheProxy;
        cacheProxy.getCacheManager().clearFeatures();
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    public FeatureStoreServices(@Autowired @NotNull FF4j fF4j) {
        Intrinsics.checkParameterIsNotNull((Object)fF4j, (String)"fF4j");
        this.fF4j = fF4j;
    }
}

