/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.rest.api.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.MonitoringServices;
import org.ff4j.services.domain.EventRepositoryApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Tag(name="Monitoring", description="The API for monitoring related operations")
@RestController
@RequestMapping(value={"${ff4j.api.context-path:/api/ff4j}/monitoring"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/ff4j/spring/rest/api/resources/MonitoringResource;", "", "monitoringServices", "Lorg/ff4j/services/MonitoringServices;", "(Lorg/ff4j/services/MonitoringServices;)V", "getMonitoringServices", "()Lorg/ff4j/services/MonitoringServices;", "getMonitoringStatus", "Lorg/springframework/http/ResponseEntity;", "Lreactor/core/publisher/Mono;", "Lorg/ff4j/services/domain/EventRepositoryApiBean;", "start", "", "end", "ff4j-spring-rest-api"})
public class MonitoringResource {
    @NotNull
    private final MonitoringServices monitoringServices;

    public MonitoringResource(@Autowired @NotNull MonitoringServices monitoringServices) {
        Intrinsics.checkNotNullParameter((Object)monitoringServices, (String)"monitoringServices");
        this.monitoringServices = monitoringServices;
    }

    @NotNull
    public MonitoringServices getMonitoringServices() {
        return this.monitoringServices;
    }

    @Operation(tags={"Monitoring"}, summary="Display Monitoring information for all features", description="The EventRepository handle to store audit events is not required")
    @ApiResponses(value={@ApiResponse(description="Status of event repository bean", responseCode="200", content={@Content(schema=@Schema(implementation=EventRepositoryApiBean.class))}), @ApiResponse(description="No event repository defined", responseCode="404")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Mono<EventRepositoryApiBean>> getMonitoringStatus(@RequestParam(value="start", required=false, defaultValue="0") long start, @RequestParam(value="end", required=false, defaultValue="0") long end) {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getMonitoringServices().getMonitoringStatus(start, end));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }
}

