/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.rest.api.exceptions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.exception.InvalidPropertyTypeException;
import org.ff4j.services.exceptions.AuthorizationNotExistsException;
import org.ff4j.services.exceptions.FeatureIdBlankException;
import org.ff4j.services.exceptions.FeatureIdNotMatchException;
import org.ff4j.services.exceptions.FeatureNotFoundException;
import org.ff4j.services.exceptions.FeatureStoreNotCached;
import org.ff4j.services.exceptions.FlippingStrategyBadRequestException;
import org.ff4j.services.exceptions.GroupExistsException;
import org.ff4j.services.exceptions.GroupNotExistsException;
import org.ff4j.services.exceptions.PropertiesBadRequestException;
import org.ff4j.services.exceptions.PropertyNameBlankException;
import org.ff4j.services.exceptions.PropertyNameNotMatchException;
import org.ff4j.services.exceptions.PropertyNotFoundException;
import org.ff4j.services.exceptions.PropertyStoreNotCached;
import org.ff4j.services.exceptions.RoleExistsException;
import org.ff4j.services.exceptions.RoleNotExistsException;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.reactive.result.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice(basePackages={"org.ff4j.spring.rest.api.resources"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0017\u00a8\u0006\u0016"}, d2={"Lorg/ff4j/spring/rest/api/exceptions/FF4jExceptionHandler;", "Lorg/springframework/web/reactive/result/method/annotation/ResponseEntityExceptionHandler;", "()V", "authorizationNotExistsException", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/http/ProblemDetail;", "badRequestHandler", "featureIdBlankException", "featureIdNotMatchException", "featureNotFoundException", "featureStoreNotCached", "flippingStrategyBadRequestException", "groupExistsException", "groupNotExistsException", "propertiesBadRequestException", "propertyNameBlankException", "propertyNameNotMatchException", "propertyNotFoundException", "propertyStoreNotCached", "propertyValueInvalidException", "roleExistsException", "roleNotExistsException", "ff4j-spring-rest-api"})
public class FF4jExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={IllegalArgumentException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> badRequestHandler() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"bad request"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={FeatureNotFoundException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> featureNotFoundException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"feature not found"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={FeatureIdBlankException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> featureIdBlankException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"feature uid cannot be blank"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={FeatureIdNotMatchException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> featureIdNotMatchException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"feature uid did not match with the requested feature uid to be created or updated"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={FlippingStrategyBadRequestException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> flippingStrategyBadRequestException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"flipping strategy specified wrongly"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={PropertiesBadRequestException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> propertiesBadRequestException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"properties specified wrongly"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={RoleExistsException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> roleExistsException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED), (String)"role already exists"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={RoleNotExistsException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> roleNotExistsException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"role does not exist"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={GroupExistsException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> groupExistsException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED), (String)"group already exists"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={GroupNotExistsException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> groupNotExistsException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"group does not exist"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={FeatureStoreNotCached.class})
    @NotNull
    public ResponseEntity<ProblemDetail> featureStoreNotCached() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"feature store is not cached"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={AuthorizationNotExistsException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> authorizationNotExistsException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"no security has been defined"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> propertyNotFoundException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"property not found"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={PropertyNameBlankException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> propertyNameBlankException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"property name cannot be blank"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={InvalidPropertyTypeException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> propertyValueInvalidException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"bad request"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={PropertyNameNotMatchException.class})
    @NotNull
    public ResponseEntity<ProblemDetail> propertyNameNotMatchException() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)"property name did not match with the requested property name to be created or updated"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={PropertyStoreNotCached.class})
    @NotNull
    public ResponseEntity<ProblemDetail> propertyStoreNotCached() {
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND), (String)"property store is not cached"));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }
}

