/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.autoconfigure.common;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.spring.boot.autoconfigure.common.FF4JConfiguration;
import org.ff4j.spring.boot.autoconfigure.common.FF4JConfigurationProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={FF4JConfiguration.class, SpringDocConfiguration.class})
@ConditionalOnClass(value={SpringDocConfiguration.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/ff4j/spring/boot/autoconfigure/common/FF4JOpenApiConfiguration;", "", "config", "Lorg/ff4j/spring/boot/autoconfigure/common/FF4JConfigurationProperties;", "springDocConfigProperties", "Lorg/springdoc/core/properties/SpringDocConfigProperties;", "(Lorg/ff4j/spring/boot/autoconfigure/common/FF4JConfigurationProperties;Lorg/springdoc/core/properties/SpringDocConfigProperties;)V", "log", "Lorg/slf4j/Logger;", "groupApiEnabled", "Lorg/springdoc/core/models/GroupedOpenApi;", "ff4j-spring-boot-autoconfigure-common"})
public class FF4JOpenApiConfiguration {
    @NotNull
    private final FF4JConfigurationProperties config;
    @NotNull
    private final SpringDocConfigProperties springDocConfigProperties;
    @NotNull
    private final Logger log;

    public FF4JOpenApiConfiguration(@NotNull FF4JConfigurationProperties config, @NotNull SpringDocConfigProperties springDocConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)springDocConfigProperties, (String)"springDocConfigProperties");
        this.config = config;
        this.springDocConfigProperties = springDocConfigProperties;
        Logger logger = LoggerFactory.getLogger(FF4JOpenApiConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
        if (!this.config.getApi().getSpringDoc().getEnabled()) {
            this.log.info("Exclude FF4J OpenAPI configuration");
            this.springDocConfigProperties.setPathsToExclude(CollectionsKt.listOf((Object)(this.config.getApi().getContextPath() + "/**")));
        }
    }

    public /* synthetic */ FF4JOpenApiConfiguration(FF4JConfigurationProperties fF4JConfigurationProperties, SpringDocConfigProperties springDocConfigProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            springDocConfigProperties = new SpringDocConfigProperties();
        }
        this(fF4JConfigurationProperties, springDocConfigProperties);
    }

    @Bean
    @ConditionalOnProperty(name={"ff4j.api.spring-doc.enabled"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public GroupedOpenApi groupApiEnabled(@NotNull SpringDocConfigProperties springDocConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)springDocConfigProperties, (String)"springDocConfigProperties");
        this.log.info("Initializing FF4J GroupedOpenApi configuration");
        String[] stringArray = new String[]{this.config.getApi().getContextPath() + "/**"};
        GroupedOpenApi groupedOpenApi = GroupedOpenApi.builder().group(this.config.getApi().getSpringDoc().getGroup()).pathsToMatch(stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)groupedOpenApi, (String)"build(...)");
        return groupedOpenApi;
    }
}

