/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.lang.model.type.NullType;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.ff4j.FF4j;
import org.ff4j.aop.Flip;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

@Component(value="ff.advisor")
public class FeatureAdvisor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureAdvisor.class);
    @Autowired
    private ApplicationContext appCtx;
    @Autowired
    private FF4j ff4j;

    public Object invoke(MethodInvocation mi) throws Throwable {
        Flip ff4jAnnotation = this.getFF4jAnnotation(mi);
        if (ff4jAnnotation != null) {
            String alterBean = ff4jAnnotation.alterBean();
            Class<?> alterClazz = ff4jAnnotation.alterClazz();
            if (Util.hasLength((String)alterBean) || Util.isValidClass(alterClazz)) {
                boolean usingAlterBean = Util.hasLength((String)alterBean) && this.appCtx.containsBean(alterBean);
                boolean usingAlterClazz = Util.isValidClass(alterClazz);
                if (usingAlterBean && alterBean.equals(this.getExecutedBeanName(mi)) || usingAlterClazz && alterClazz == this.getExecutedClass(mi)) {
                    return mi.proceed();
                }
                boolean isFeatureToggled = this.check(ff4jAnnotation, mi);
                if (isFeatureToggled) {
                    if (usingAlterBean) {
                        return this.invokeAlterBean(mi, alterBean);
                    }
                    if (usingAlterClazz) {
                        return this.invokeAlterClazz(mi, ff4jAnnotation);
                    }
                }
            } else if (!this.check(ff4jAnnotation, mi)) {
                return null;
            }
        }
        return mi.proceed();
    }

    protected boolean check(Flip ff, MethodInvocation mi) {
        FlippingExecutionContext context = this.getFlippingContext(ff, mi);
        String featureId = ff.name();
        if (ff.flippingStrategy() != NullType.class) {
            String fsClassName = ff.flippingStrategy().getName();
            FlippingStrategy fs = MappingUtil.instanceFlippingStrategy((String)featureId, (String)fsClassName, (Map)MappingUtil.toMap((String)ff.flippingInitParams()));
            return this.getFf4j().checkOverridingStrategy(featureId, fs, context);
        }
        return this.getFf4j().check(featureId, context);
    }

    protected Flip getFF4jAnnotation(MethodInvocation mi) {
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)mi.getMethod(), Flip.class)) {
            return (Flip)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)mi.getMethod(), Flip.class);
        }
        Class<?> currentInterface = mi.getMethod().getDeclaringClass();
        if (AnnotatedElementUtils.hasAnnotation(currentInterface, Flip.class)) {
            return (Flip)AnnotatedElementUtils.findMergedAnnotation(currentInterface, Flip.class);
        }
        Class<?> currentImplementation = this.getExecutedClass(mi);
        if (AnnotatedElementUtils.hasAnnotation(currentImplementation, Flip.class)) {
            return (Flip)AnnotatedElementUtils.findMergedAnnotation(currentImplementation, Flip.class);
        }
        return null;
    }

    protected FlippingExecutionContext getFlippingContext(Flip ff, MethodInvocation mi) {
        switch (ff.contextLocation()) {
            case FF4J: {
                return this.getFf4j().getCurrentContext();
            }
            case PARAMETER: {
                int p = 0;
                for (Class<?> cls : mi.getMethod().getParameterTypes()) {
                    if (FlippingExecutionContext.class.isAssignableFrom(cls)) {
                        return (FlippingExecutionContext)FlippingExecutionContext.class.cast(mi.getArguments()[p]);
                    }
                    ++p;
                }
                break;
            }
        }
        return null;
    }

    protected Class<?> getExecutedClass(MethodInvocation pMInvoc) {
        Class executedClass = null;
        Object ref = pMInvoc.getThis();
        if (ref != null) {
            executedClass = AopUtils.getTargetClass((Object)ref);
        }
        if (executedClass == null) {
            throw new IllegalArgumentException("ff4j-aop: Static methods cannot be feature flipped");
        }
        return executedClass;
    }

    protected String getExecutedBeanName(MethodInvocation mi) {
        Class<?> targetClass = this.getExecutedClass(mi);
        Component component = targetClass.getAnnotation(Component.class);
        if (component != null) {
            return component.value();
        }
        Service service = targetClass.getAnnotation(Service.class);
        if (service != null) {
            return service.value();
        }
        Repository repo = targetClass.getAnnotation(Repository.class);
        if (repo != null) {
            return repo.value();
        }
        try {
            for (String beanName : this.appCtx.getBeanDefinitionNames()) {
                Object bean = this.appCtx.getBean(beanName);
                if (AopUtils.isJdkDynamicProxy((Object)bean)) {
                    bean = ((Advised)bean).getTargetSource().getTarget();
                }
                if (bean == null || !bean.getClass().isAssignableFrom(targetClass)) continue;
                return beanName;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("ff4j-aop: Cannot read bheind proxy target", e);
        }
        throw new IllegalArgumentException("ff4j-aop: Feature bean must be annotated as a Service or a Component");
    }

    private IllegalArgumentException makeIllegalArgumentException(String message, Exception exception) {
        return new IllegalArgumentException(message, exception);
    }

    protected Object invokeAlterBean(MethodInvocation mi, String alterBeanName) throws Throwable {
        Method method = mi.getMethod();
        try {
            LOGGER.debug("FeatureFlipping on method:{} class:{}", (Object)method.getName(), (Object)method.getDeclaringClass().getName());
            Object alterbean = this.appCtx.getBean(alterBeanName, method.getDeclaringClass());
            return method.invoke(alterbean, mi.getArguments());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!this.ff4j.isAlterBeanThrowInvocationTargetException() && invocationTargetException.getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw this.makeIllegalArgumentException("ff4j-aop: Cannot invoke method " + method.getName() + " on bean " + alterBeanName, invocationTargetException);
        }
        catch (Exception exception) {
            throw this.makeIllegalArgumentException("ff4j-aop: Cannot invoke method " + method.getName() + " on bean " + alterBeanName, exception);
        }
    }

    protected Object invokeAlterClazz(MethodInvocation mi, Flip ff) throws Throwable {
        Class<?> alterClazz = ff.alterClazz();
        Method method = mi.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            for (Object bean : this.appCtx.getBeansOfType(declaringClass).values()) {
                if ((!AopUtils.isJdkDynamicProxy(bean) || !((Advised)bean).getTargetSource().getTarget().getClass().equals(alterClazz)) && !AopProxyUtils.ultimateTargetClass(bean).equals(alterClazz)) continue;
                return mi.getMethod().invoke(bean, mi.getArguments());
            }
            return mi.getMethod().invoke(ff.alterClazz().newInstance(), mi.getArguments());
        }
        catch (IllegalAccessException e) {
            throw this.makeIllegalArgumentException("ff4j-aop: Cannot invoke " + method.getName() + " on alterbean " + String.valueOf(declaringClass) + " please check visibility", e);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!this.ff4j.isAlterBeanThrowInvocationTargetException() && invocationTargetException.getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw this.makeIllegalArgumentException("ff4j-aop: Cannot invoke " + method.getName() + " on alterbean " + String.valueOf(declaringClass) + " please check signatures", invocationTargetException);
        }
        catch (Exception exception) {
            throw this.makeIllegalArgumentException("ff4j-aop: Cannot invoke " + method.getName() + " on alterbean " + String.valueOf(declaringClass) + " please check signatures", exception);
        }
    }

    public FF4j getFf4j() {
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }
}

