/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.fakereplace.client.ClassData;
import org.fakereplace.client.ContentSource;
import org.fakereplace.client.FakeReplaceClient;
import org.fakereplace.client.ResourceData;
import org.fakereplace.maven.Util;

public class FakereplaceMojo
extends AbstractMojo {
    private String path;
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String fileName = this.project.getArtifact().getFile().getName();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.project.getArtifact().getFile());
            File file = new File(this.path);
            HashMap<String, ClassData> classes = new HashMap<String, ClassData>();
            HashMap<String, ResourceData> resources = new HashMap<String, ResourceData>();
            this.handleClassesDirectory(file, file, classes);
            this.handleArtifact(zipFile, resources);
            FakeReplaceClient.run((String)fileName, classes, resources);
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Error running fakereplace: ", t);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleArtifact(final ZipFile zipFile, Map<String, ResourceData> resources) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            final ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            resources.put(entry.getName(), new ResourceData(entry.getName(), entry.getTime(), new ContentSource(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public byte[] getData() throws IOException {
                    InputStream stream = zipFile.getInputStream(entry);
                    try {
                        byte[] byArray = Util.getBytesFromStream(stream);
                        return byArray;
                    }
                    finally {
                        stream.close();
                    }
                }
            }));
        }
    }

    private void handleClassesDirectory(File base, File dir, Map<String, ClassData> classes) {
        for (final File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.handleClassesDirectory(base, file, classes);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String relFile = file.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
            String className = relFile.substring(0, relFile.length() - ".class".length()).replace("/", ".");
            classes.put(className, new ClassData(className, file.lastModified(), new ContentSource(){

                public byte[] getData() throws IOException {
                    return Util.getBytesFromFile(file);
                }
            }));
        }
    }
}

