/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.runtime;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.fakereplace.boot.DefaultEnvironment;
import org.fakereplace.runtime.MethodIdentifierStore;

public class VirtualDelegator {
    private static final Set<VirtualDelegatorData> delegatingMethods = new CopyOnWriteArraySet<VirtualDelegatorData>();

    public static void add(ClassLoader loader, String className, String methodName, String methodDesc) {
        delegatingMethods.add(new VirtualDelegatorData(loader, className, methodName, methodDesc));
    }

    public static void clear(ClassLoader classLoader, String className) {
        Iterator<VirtualDelegatorData> it = delegatingMethods.iterator();
        while (it.hasNext()) {
            VirtualDelegatorData i = it.next();
            if (i.getLoader() != classLoader || !className.equals(i.getClassName())) continue;
            it.remove();
        }
    }

    public static boolean contains(Object val, String callingClassName, String methodName, String methodDesc) {
        if (!DefaultEnvironment.getEnvironment().isClassReplaceable(val.getClass().getName(), val.getClass().getClassLoader())) {
            return false;
        }
        Class<?> c = val.getClass();
        while (!c.getName().equals(callingClassName)) {
            VirtualDelegatorData i = new VirtualDelegatorData(c.getClassLoader(), c.getName(), methodName, methodDesc);
            if (delegatingMethods.contains(i)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static Object run(Object val, String methodName, String methodDesc, Object[] params) {
        try {
            Method meth = val.getClass().getMethod("______REDEFINED_METHOD_DELEGATOR_$", Integer.TYPE, Object[].class);
            int methodIdentifier = MethodIdentifierStore.instance().getMethodNumber(methodName, methodDesc);
            return meth.invoke(val, methodIdentifier, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class VirtualDelegatorData {
        private final ClassLoader loader;
        private final String className;
        private final String methodName;
        private final String methodDesc;

        public ClassLoader getLoader() {
            return this.loader;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDesc() {
            return this.methodDesc;
        }

        public VirtualDelegatorData(ClassLoader loader, String className, String methodName, String methodDesc) {
            this.loader = loader;
            this.className = className;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.methodDesc == null ? 0 : this.methodDesc.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualDelegatorData other = (VirtualDelegatorData)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
                return false;
            }
            if (this.methodDesc == null ? other.methodDesc != null : !this.methodDesc.equals(other.methodDesc)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }
    }
}

