/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.replacement;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.fakereplace.BuiltinClassData;
import org.fakereplace.Transformer;
import org.fakereplace.classloading.ProxyDefinitionStore;
import org.fakereplace.data.AnnotationDataStore;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassDataBuilder;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.MemberType;
import org.fakereplace.data.MethodData;
import org.fakereplace.javassist.bytecode.AnnotationsAttribute;
import org.fakereplace.javassist.bytecode.AttributeInfo;
import org.fakereplace.javassist.bytecode.BadBytecode;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeAttribute;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.Descriptor;
import org.fakereplace.javassist.bytecode.DuplicateMemberException;
import org.fakereplace.javassist.bytecode.ExceptionsAttribute;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.javassist.bytecode.ParameterAnnotationsAttribute;
import org.fakereplace.javassist.bytecode.SignatureAttribute;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.util.Boxing;
import org.fakereplace.manip.util.ManipulationUtils;
import org.fakereplace.manip.util.ParameterRewriter;
import org.fakereplace.replacement.AnnotationReplacer;
import org.fakereplace.runtime.MethodIdentifierStore;
import org.fakereplace.util.AccessFlagUtils;
import org.fakereplace.util.DescriptorUtils;

public class MethodReplacer {
    private static final Logger logger = Logger.getLogger(MethodReplacer.class);

    public static void handleMethodReplacement(ClassFile file, ClassLoader loader, Class<?> oldClass, ClassDataBuilder builder, Set<Class<?>> superclassesToHotswap) {
        AttributeInfo staticCodeAttribute = null;
        CodeAttribute virtualCodeAttribute = null;
        CodeAttribute constructorCodeAttribute = null;
        try {
            MethodInfo virtMethod = new MethodInfo(file.getConstPool(), "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
            virtMethod.setAccessFlags(1);
            if (file.isInterface()) {
                virtMethod.setAccessFlags(5121);
            } else {
                virtMethod.setAccessFlags(4097);
                Bytecode b = new Bytecode(file.getConstPool(), 0, 3);
                if (BuiltinClassData.skipInstrumentation(file.getSuperclass())) {
                    b.add(1);
                    b.add(176);
                } else {
                    b.add(42);
                    b.add(27);
                    b.add(44);
                    b.addInvokespecial(file.getSuperclass(), "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
                    b.add(176);
                }
                virtualCodeAttribute = b.toCodeAttribute();
                virtMethod.setCodeAttribute(virtualCodeAttribute);
                MethodInfo m = new MethodInfo(file.getConstPool(), "______REDEFINED_STATIC_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
                m.setAccessFlags(4105);
                b = new Bytecode(file.getConstPool(), 0, 3);
                b.add(1);
                b.add(176);
                staticCodeAttribute = b.toCodeAttribute();
                m.setCodeAttribute((CodeAttribute)staticCodeAttribute);
                file.addMethod(m);
                m = new MethodInfo(file.getConstPool(), "<init>", "(I[Ljava/lang/Object;Lorg/fakereplace/ConstructorArgument;)V");
                m.setAccessFlags(4097);
                b = new Bytecode(file.getConstPool(), 0, 4);
                if (ManipulationUtils.addBogusConstructorCall(file, b)) {
                    constructorCodeAttribute = b.toCodeAttribute();
                    m.setCodeAttribute(constructorCodeAttribute);
                    constructorCodeAttribute.setMaxLocals(6);
                    file.addMethod(m);
                }
            }
            file.addMethod(virtMethod);
        }
        catch (DuplicateMemberException e) {
            e.printStackTrace();
        }
        BaseClassData data = builder.getBaseData();
        HashSet<MethodData> methods = new HashSet<MethodData>();
        methods.addAll(data.getMethods());
        ListIterator it = file.getMethods().listIterator();
        while (it.hasNext()) {
            MethodInfo m = (MethodInfo)it.next();
            MethodData md = null;
            boolean upgradedVisibility = false;
            for (MethodData i : methods) {
                Executable meth;
                if (!i.getMethodName().equals(m.getName()) || !i.getDescriptor().equals(m.getDescriptor())) continue;
                if (i.getAccessFlags() != m.getAccessFlags()) {
                    if (AccessFlagUtils.upgradeVisibility(m.getAccessFlags(), i.getAccessFlags())) {
                        upgradedVisibility = true;
                    } else if (!AccessFlagUtils.downgradeVisibility(m.getAccessFlags(), i.getAccessFlags())) continue;
                }
                m.setAccessFlags(i.getAccessFlags());
                if (m.getName().equals("<init>")) {
                    try {
                        meth = i.getConstructor(oldClass);
                        AnnotationDataStore.recordConstructorAnnotations(meth, (AnnotationsAttribute)m.getAttribute("RuntimeVisibleAnnotations"));
                        m.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), meth));
                        m.addAttribute(AnnotationReplacer.duplicateParameterAnnotationsAttribute(file.getConstPool(), meth));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!m.getName().equals("<clinit>")) {
                    try {
                        meth = i.getMethod(oldClass);
                        AnnotationDataStore.recordMethodAnnotations(meth, (AnnotationsAttribute)m.getAttribute("RuntimeVisibleAnnotations"));
                        AnnotationDataStore.recordMethodParameterAnnotations(meth, (ParameterAnnotationsAttribute)m.getAttribute("RuntimeVisibleParameterAnnotations"));
                        m.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), meth));
                        m.addAttribute(AnnotationReplacer.duplicateParameterAnnotationsAttribute(file.getConstPool(), meth));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                md = i;
                break;
            }
            if (m.getName().equals("______REDEFINED_METHOD_DELEGATOR_$") || m.getName().equals("______REDEFINED_STATIC_METHOD_DELEGATOR_$")) break;
            if (md == null || upgradedVisibility) {
                Class<?> c;
                if ((m.getAccessFlags() & 8) != 0) {
                    c = MethodReplacer.addMethod(file, loader, m, builder, (CodeAttribute)staticCodeAttribute, true, oldClass);
                    if (c != null) {
                        superclassesToHotswap.add(c);
                    }
                } else if (m.getName().equals("<init>")) {
                    MethodReplacer.addConstructor(file, loader, m, builder, constructorCodeAttribute, oldClass);
                } else if (!m.getName().equals("<clinit>") && (c = MethodReplacer.addMethod(file, loader, m, builder, virtualCodeAttribute, false, oldClass)) != null) {
                    superclassesToHotswap.add(c);
                }
                if (!upgradedVisibility) {
                    it.remove();
                }
            } else if (md != null) {
                methods.remove(md);
            }
            if (!upgradedVisibility || md == null) continue;
            methods.remove(md);
        }
        for (MethodData md : methods) {
            if (md.getType() != MemberType.NORMAL) continue;
            MethodReplacer.createRemovedMethod(file, md, oldClass, builder);
        }
        if (!file.isInterface()) {
            try {
                Bytecode rcode = new Bytecode(staticCodeAttribute.getConstPool());
                rcode.add(1);
                rcode.add(176);
                CodeIterator cit = ((CodeAttribute)staticCodeAttribute).iterator();
                cit.append(rcode.get());
                ((CodeAttribute)staticCodeAttribute).computeMaxStack();
                virtualCodeAttribute.computeMaxStack();
                if (constructorCodeAttribute != null) {
                    constructorCodeAttribute.computeMaxStack();
                }
            }
            catch (BadBytecode e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateProxyInvocationBytecode(MethodInfo mInfo, ConstPool constPool, int methodNumber, String className, ClassLoader loader, boolean staticMethod, boolean isInterface) throws BadBytecode {
        MethodInfo nInfo;
        String proxyName = ProxyDefinitionStore.getProxyName();
        ClassFile proxy = new ClassFile(false, proxyName, "java.lang.Object");
        proxy.setVersionToJava5();
        proxy.setAccessFlags(1);
        if (staticMethod) {
            nInfo = new MethodInfo(proxy.getConstPool(), mInfo.getName(), mInfo.getDescriptor());
        } else {
            String nDesc = "(" + DescriptorUtils.extToInt(className) + mInfo.getDescriptor().substring(1);
            nInfo = new MethodInfo(proxy.getConstPool(), mInfo.getName(), nDesc);
        }
        MethodReplacer.copyMethodAttributes(mInfo, nInfo);
        nInfo.setAccessFlags(9);
        Bytecode proxyBytecode = new Bytecode(proxy.getConstPool());
        int paramOffset = 0;
        if (!staticMethod) {
            proxyBytecode.addAload(0);
            paramOffset = 1;
        }
        int scind = proxy.getConstPool().addIntegerInfo(methodNumber);
        proxyBytecode.addLdc(scind);
        String[] types = DescriptorUtils.descriptorStringToParameterArray(mInfo.getDescriptor());
        int index = proxyBytecode.getConstPool().addIntegerInfo(types.length);
        proxyBytecode.addLdc(index);
        proxyBytecode.addAnewarray("java.lang.Object");
        int locals = types.length + paramOffset;
        for (int i = 0; i < types.length; ++i) {
            proxyBytecode.add(89);
            index = proxyBytecode.getConstPool().addIntegerInfo(i);
            proxyBytecode.addLdc(index);
            char tp = types[i].charAt(0);
            if (tp != 'L' && tp != '[') {
                switch (tp) {
                    case 'J': {
                        proxyBytecode.addLload(i + paramOffset);
                        ++locals;
                        break;
                    }
                    case 'D': {
                        proxyBytecode.addDload(i + paramOffset);
                        ++locals;
                        break;
                    }
                    case 'F': {
                        proxyBytecode.addFload(i + paramOffset);
                        break;
                    }
                    default: {
                        proxyBytecode.addIload(i + paramOffset);
                    }
                }
                Boxing.box(proxyBytecode, tp);
            } else {
                proxyBytecode.addAload(i + paramOffset);
            }
            proxyBytecode.add(83);
        }
        if (staticMethod) {
            proxyBytecode.addInvokestatic(className, "______REDEFINED_STATIC_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
        } else if (isInterface) {
            proxyBytecode.addInvokeinterface(className, "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;", 3);
        } else {
            proxyBytecode.addInvokevirtual(className, "______REDEFINED_METHOD_DELEGATOR_$", "(I[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        ManipulationUtils.MethodReturnRewriter.addReturnProxyMethod(mInfo.getDescriptor(), proxyBytecode);
        CodeAttribute ca = proxyBytecode.toCodeAttribute();
        ca.setMaxLocals(locals);
        ca.computeMaxStack();
        nInfo.setCodeAttribute(ca);
        if (!staticMethod) {
            MethodInfo method = new MethodInfo(proxy.getConstPool(), mInfo.getName(), mInfo.getDescriptor());
            method.setAccessFlags(mInfo.getAccessFlags());
            if ((method.getAccessFlags() & 0x400) == 0) {
                Bytecode b = new Bytecode(proxy.getConstPool());
                String ret = DescriptorUtils.getReturnType(mInfo.getDescriptor());
                if (ret.length() == 1) {
                    if (ret.equals("V")) {
                        b.add(177);
                    } else if (ret.equals("D")) {
                        b.add(14);
                        b.add(175);
                    } else if (ret.equals("F")) {
                        b.add(11);
                        b.add(174);
                    } else if (ret.equals("J")) {
                        b.add(9);
                        b.add(173);
                    } else {
                        b.add(3);
                        b.add(172);
                    }
                } else {
                    b.add(1);
                    b.add(176);
                }
                method.setCodeAttribute(b.toCodeAttribute());
                method.getCodeAttribute().computeMaxStack();
                method.getCodeAttribute().setMaxLocals(locals);
            }
            MethodReplacer.copyMethodAttributes(mInfo, method);
            try {
                proxy.addMethod(method);
            }
            catch (DuplicateMemberException e) {
                e.printStackTrace();
            }
        }
        try {
            proxy.addMethod(nInfo);
        }
        catch (DuplicateMemberException e) {
            e.printStackTrace();
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bytes);
            proxy.write(dos);
            ProxyDefinitionStore.saveProxyDefinition(loader, proxyName, bytes.toByteArray());
            return proxyName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> addMethod(ClassFile file, ClassLoader loader, MethodInfo mInfo, ClassDataBuilder builder, CodeAttribute bytecode, boolean staticMethod, Class oldClass) {
        int methodCount = MethodIdentifierStore.instance().getMethodNumber(mInfo.getName(), mInfo.getDescriptor());
        try {
            if ((0x400 & mInfo.getAccessFlags()) == 0) {
                MethodReplacer.generateBoxedConditionalCodeBlock(methodCount, mInfo, file.getConstPool(), bytecode, staticMethod, false);
            }
            String proxyName = MethodReplacer.generateProxyInvocationBytecode(mInfo, file.getConstPool(), methodCount, file.getName(), loader, staticMethod, file.isInterface());
            ClassDataStore.instance().registerProxyName(oldClass, proxyName);
            String newMethodDesc = mInfo.getDescriptor();
            if (!staticMethod) {
                newMethodDesc = "(L" + Descriptor.toJvmName(file.getName()) + ";" + newMethodDesc.substring(1);
            }
            Transformer.getManipulator().replaceVirtualMethodInvokationWithStatic(file.getName(), proxyName, mInfo.getName(), mInfo.getDescriptor(), newMethodDesc, loader);
            MethodData md = builder.addFakeMethod(mInfo.getName(), mInfo.getDescriptor(), proxyName, mInfo.getAccessFlags());
            ClassDataStore.instance().registerReplacedMethod(proxyName, md);
            if (!staticMethod) {
                for (Class sup = oldClass.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                    for (Method m : sup.getDeclaredMethods()) {
                        if (!m.getName().equals(mInfo.getName()) || !DescriptorUtils.getDescriptor(m).equals(mInfo.getDescriptor())) continue;
                        Transformer.getManipulator().rewriteSubclassCalls(file.getName(), loader, sup.getName(), sup.getClassLoader(), mInfo.getName(), mInfo.getDescriptor());
                        return sup;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void generateBoxedConditionalCodeBlock(int methodNumber, MethodInfo mInfo, ConstPool methodConstPool, CodeAttribute addedMethod, boolean staticMethod, boolean constructor) throws BadBytecode {
        Bytecode bc = new Bytecode(mInfo.getConstPool());
        CodeAttribute ca = (CodeAttribute)mInfo.getCodeAttribute().copy(mInfo.getConstPool(), Collections.emptyMap());
        if (staticMethod) {
            bc.addOpcode(26);
        } else {
            bc.addOpcode(27);
        }
        int methodCountIndex = methodConstPool.addIntegerInfo(methodNumber);
        bc.addLdc(methodCountIndex);
        bc.addOpcode(160);
        int addedCodeLength = ParameterRewriter.mangleParameters(staticMethod, constructor, ca, mInfo.getDescriptor(), ca.getMaxLocals());
        int newMax = ca.getMaxLocals() + 2;
        if (constructor) {
            ++newMax;
        }
        if (newMax > addedMethod.getMaxLocals()) {
            addedMethod.setMaxLocals(newMax);
        }
        int offset = ca.getCodeLength();
        ManipulationUtils.add16bit(bc, offset + 3);
        CodeIterator newInfo = ca.iterator();
        newInfo.insert(bc.get());
        addedMethod.iterator().insert(ca.getCode());
        int exOffset = bc.length() + addedCodeLength;
        for (int i = 0; i < mInfo.getCodeAttribute().getExceptionTable().size(); ++i) {
            int start = mInfo.getCodeAttribute().getExceptionTable().startPc(i) + exOffset;
            int end = mInfo.getCodeAttribute().getExceptionTable().endPc(i) + exOffset;
            int handler = mInfo.getCodeAttribute().getExceptionTable().handlerPc(i) + exOffset;
            int type = mInfo.getCodeAttribute().getExceptionTable().catchType(i);
            addedMethod.getExceptionTable().add(start, end, handler, type);
        }
        if (!constructor) {
            ManipulationUtils.MethodReturnRewriter.rewriteFakeMethod(addedMethod.iterator(), mInfo.getDescriptor());
        }
    }

    private static void createRemovedMethod(ClassFile file, MethodData md, Class<?> oldClass, ClassDataBuilder builder) {
        Executable meth;
        if (md.getMethodName().equals("<clinit>")) {
            return;
        }
        MethodInfo m = new MethodInfo(file.getConstPool(), md.getMethodName(), md.getDescriptor());
        m.setAccessFlags(md.getAccessFlags());
        if (md.getMethodName().equals("<init>")) {
            try {
                meth = md.getConstructor(oldClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Error accessing existing constructor via reflection in not found", e);
            }
            m.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), meth));
        } else {
            try {
                meth = md.getMethod(oldClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Error accessing existing method via reflection in not found", e);
            }
            m.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), meth));
        }
        Bytecode b = new Bytecode(file.getConstPool(), 5, 3);
        b.addNew("java.lang.NoSuchMethodError");
        b.add(89);
        b.addInvokespecial("java.lang.NoSuchMethodError", "<init>", "()V");
        b.add(191);
        CodeAttribute ca = b.toCodeAttribute();
        m.setCodeAttribute(ca);
        try {
            ca.computeMaxStack();
            file.addMethod(m);
        }
        catch (DuplicateMemberException e) {
            logger.error("Duplicate error", e);
        }
        catch (BadBytecode e) {
            logger.error("Bad bytecode", e);
        }
        builder.removeRethod(md);
    }

    private static void addConstructor(ClassFile file, ClassLoader loader, MethodInfo mInfo, ClassDataBuilder builder, CodeAttribute bytecode, Class<?> oldClass) {
        int methodCount = MethodIdentifierStore.instance().getMethodNumber(mInfo.getName(), mInfo.getDescriptor());
        try {
            MethodReplacer.generateBoxedConditionalCodeBlock(methodCount, mInfo, file.getConstPool(), bytecode, false, true);
            String proxyName = MethodReplacer.generateFakeConstructorBytecode(mInfo, file.getConstPool(), methodCount, file.getName(), loader);
            ClassDataStore.instance().registerProxyName(oldClass, proxyName);
            Transformer.getManipulator().rewriteConstructorAccess(file.getName(), mInfo.getDescriptor(), methodCount, loader);
            MethodData md = builder.addFakeConstructor(mInfo.getName(), mInfo.getDescriptor(), proxyName, mInfo.getAccessFlags(), methodCount);
            ClassDataStore.instance().registerReplacedMethod(proxyName, md);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String generateFakeConstructorBytecode(MethodInfo mInfo, ConstPool constPool, int methodNumber, String className, ClassLoader loader) throws BadBytecode {
        String proxyName = ProxyDefinitionStore.getProxyName();
        ClassFile proxy = new ClassFile(false, proxyName, "java.lang.Object");
        proxy.setVersionToJava5();
        proxy.setAccessFlags(1);
        String[] types = DescriptorUtils.descriptorStringToParameterArray(mInfo.getDescriptor());
        Bytecode b = new Bytecode(proxy.getConstPool());
        b.add(42);
        b.addInvokespecial("java.lang.Object", "<init>", "()V");
        b.add(177);
        MethodInfo method = new MethodInfo(proxy.getConstPool(), mInfo.getName(), mInfo.getDescriptor());
        method.setAccessFlags(mInfo.getAccessFlags());
        method.setCodeAttribute(b.toCodeAttribute());
        method.getCodeAttribute().computeMaxStack();
        method.getCodeAttribute().setMaxLocals(types.length + 1);
        MethodReplacer.copyMethodAttributes(mInfo, method);
        try {
            proxy.addMethod(method);
        }
        catch (DuplicateMemberException e) {
            e.printStackTrace();
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bytes);
            proxy.write(dos);
            ProxyDefinitionStore.saveProxyDefinition(loader, proxyName, bytes.toByteArray());
            return proxyName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyMethodAttributes(MethodInfo oldMethod, MethodInfo newMethod) {
        AttributeInfo newAnnotations;
        AnnotationsAttribute annotations = (AnnotationsAttribute)oldMethod.getAttribute("RuntimeVisibleAnnotations");
        ParameterAnnotationsAttribute pannotations = (ParameterAnnotationsAttribute)oldMethod.getAttribute("RuntimeVisibleParameterAnnotations");
        ExceptionsAttribute exAt = (ExceptionsAttribute)oldMethod.getAttribute("Exceptions");
        SignatureAttribute sigAt = (SignatureAttribute)oldMethod.getAttribute("Signature");
        if (annotations != null) {
            newAnnotations = annotations.copy(newMethod.getConstPool(), Collections.EMPTY_MAP);
            newMethod.addAttribute(newAnnotations);
        }
        if (pannotations != null) {
            newAnnotations = pannotations.copy(newMethod.getConstPool(), Collections.EMPTY_MAP);
            newMethod.addAttribute(newAnnotations);
        }
        if (sigAt != null) {
            newAnnotations = sigAt.copy(newMethod.getConstPool(), Collections.EMPTY_MAP);
            newMethod.addAttribute(newAnnotations);
        }
        if (exAt != null) {
            newAnnotations = exAt.copy(newMethod.getConstPool(), Collections.EMPTY_MAP);
            newMethod.addAttribute(newAnnotations);
        }
    }
}

