/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.replacement;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import org.fakereplace.Transformer;
import org.fakereplace.classloading.ProxyDefinitionStore;
import org.fakereplace.data.AnnotationDataStore;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassDataBuilder;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.FieldData;
import org.fakereplace.data.MemberType;
import org.fakereplace.javassist.bytecode.AnnotationsAttribute;
import org.fakereplace.javassist.bytecode.AttributeInfo;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.DuplicateMemberException;
import org.fakereplace.javassist.bytecode.FieldInfo;
import org.fakereplace.javassist.bytecode.SignatureAttribute;
import org.fakereplace.manip.StaticFieldClassFactory;
import org.fakereplace.manip.data.AddedFieldData;
import org.fakereplace.reflection.FieldAccessor;
import org.fakereplace.replacement.AnnotationReplacer;
import org.fakereplace.runtime.FieldReferenceDataStore;

public class FieldReplacer {
    public static void handleFieldReplacement(ClassFile file, ClassLoader loader, Class<?> oldClass, ClassDataBuilder builder) {
        BaseClassData data = builder.getBaseData();
        HashSet<FieldData> fields = new HashSet<FieldData>();
        fields.addAll(data.getFields());
        ListIterator it = file.getFields().listIterator();
        int noAddedFields = 0;
        ArrayList<AddedFieldData> addedFields = new ArrayList<AddedFieldData>();
        while (it.hasNext()) {
            FieldInfo m = (FieldInfo)it.next();
            FieldData md = null;
            for (FieldData i : fields) {
                if (i.getName().equals(m.getName()) && i.getType().equals(m.getDescriptor()) && i.getAccessFlags() == m.getAccessFlags()) {
                    try {
                        Field field = i.getField(oldClass);
                        AnnotationDataStore.recordFieldAnnotations(field, (AnnotationsAttribute)m.getAttribute("RuntimeVisibleAnnotations"));
                        m.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), field));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    md = i;
                    break;
                }
                if (i.getName().equals(m.getName()) && i.getType().equals(m.getDescriptor()) && (i.getAccessFlags() | 8) != (m.getAccessFlags() | 8)) continue;
            }
            if (md == null) {
                if ((m.getAccessFlags() & 8) != 0) {
                    FieldReplacer.addStaticField(file, loader, m, builder, oldClass);
                } else {
                    int fieldNo = FieldReplacer.addInstanceField(file, loader, m, builder, oldClass);
                    addedFields.add(new AddedFieldData(fieldNo, m.getName(), m.getDescriptor(), file.getName(), loader));
                    ++noAddedFields;
                }
                it.remove();
                continue;
            }
            fields.remove(md);
        }
        for (FieldData md : fields) {
            if (md.getMemberType() != MemberType.NORMAL) continue;
            FieldInfo old = new FieldInfo(file.getConstPool(), md.getName(), md.getType());
            old.setAccessFlags(md.getAccessFlags());
            builder.removeField(md);
            try {
                Field field = md.getField(oldClass);
                file.addField(old);
                old.addAttribute(AnnotationReplacer.duplicateAnnotationsAttribute(file.getConstPool(), field));
            }
            catch (DuplicateMemberException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        for (AddedFieldData a : addedFields) {
            Transformer.getManipulator().rewriteInstanceFieldAccess(a);
        }
    }

    private static void addStaticField(ClassFile file, ClassLoader loader, FieldInfo m, ClassDataBuilder builder, Class<?> oldClass) {
        String sig = null;
        SignatureAttribute sat = (SignatureAttribute)m.getAttribute("Signature");
        if (sat != null) {
            sig = sat.getSignature();
        }
        String proxyName = StaticFieldClassFactory.getStaticFieldClass(oldClass, m.getName(), m.getDescriptor(), sig);
        try {
            Field fieldFromProxy = loader.loadClass(proxyName).getDeclaredField(m.getName());
            AnnotationDataStore.recordFieldAnnotations(fieldFromProxy, (AnnotationsAttribute)m.getAttribute("RuntimeVisibleAnnotations"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Transformer.getManipulator().rewriteStaticFieldAccess(file.getName(), proxyName, m.getName(), loader);
        builder.addFakeField(m, proxyName, m.getAccessFlags());
    }

    private static int addInstanceField(ClassFile file, ClassLoader loader, FieldInfo m, ClassDataBuilder builder, Class<?> oldClass) {
        String sig = null;
        SignatureAttribute sigat = (SignatureAttribute)m.getAttribute("Signature");
        if (sigat != null) {
            sig = sigat.getSignature();
        }
        int fieldNo = FieldReferenceDataStore.instance().getFieldNo(m.getName(), m.getDescriptor(), sig);
        String proxyName = ProxyDefinitionStore.getProxyName();
        ClassFile proxy = new ClassFile(false, proxyName, "java.lang.Object");
        ClassDataStore.instance().registerProxyName(oldClass, proxyName);
        FieldAccessor accessor = new FieldAccessor(oldClass, fieldNo);
        ClassDataStore.instance().registerFieldAccessor(proxyName, accessor);
        proxy.setAccessFlags(1);
        FieldInfo newField = new FieldInfo(proxy.getConstPool(), m.getName(), m.getDescriptor());
        newField.setAccessFlags(m.getAccessFlags());
        FieldReplacer.copyFieldAttributes(m, newField);
        try {
            proxy.addField(newField);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bytes);
            try {
                proxy.write(dos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ProxyDefinitionStore.saveProxyDefinition(loader, proxyName, bytes.toByteArray());
            builder.addFakeField(newField, proxyName, m.getAccessFlags());
        }
        catch (DuplicateMemberException e) {
            // empty catch block
        }
        return fieldNo;
    }

    public static void copyFieldAttributes(FieldInfo oldField, FieldInfo newField) {
        AttributeInfo newAnnotations;
        AnnotationsAttribute annotations = (AnnotationsAttribute)oldField.getAttribute("RuntimeVisibleAnnotations");
        SignatureAttribute sigAt = (SignatureAttribute)oldField.getAttribute("Signature");
        if (annotations != null) {
            newAnnotations = annotations.copy(newField.getConstPool(), Collections.EMPTY_MAP);
            newField.addAttribute(newAnnotations);
        }
        if (sigAt != null) {
            newAnnotations = sigAt.copy(newField.getConstPool(), Collections.EMPTY_MAP);
            newField.addAttribute(newAnnotations);
        }
    }
}

