/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip.util;

import org.fakereplace.javassist.bytecode.BadBytecode;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.CodeAttribute;
import org.fakereplace.manip.util.Boxing;
import org.fakereplace.util.DescriptorUtils;

public class ParameterRewriter {
    public static int mangleParameters(boolean staticMethod, boolean constructor, CodeAttribute attribute, String methodSigniture, int existingLocalVaraiables) {
        try {
            int offset = 0;
            String[] data = DescriptorUtils.descriptorStringToParameterArray(methodSigniture);
            if (!staticMethod) {
                offset = 1;
            }
            attribute.insertLocalVar(offset, 1);
            attribute.insertLocalVar(offset, 1);
            if (constructor) {
                attribute.insertLocalVar(offset, 1);
            }
            Bytecode code = new Bytecode(attribute.getConstPool());
            int varpos = offset + 2;
            if (constructor) {
                ++varpos;
            }
            block14: for (int i = 0; i < data.length; ++i) {
                if (staticMethod) {
                    code.add(43);
                } else {
                    code.add(44);
                }
                int index = attribute.getConstPool().addIntegerInfo(i);
                code.addLdc(index);
                code.add(50);
                switch (data[i].charAt(0)) {
                    case 'L': {
                        code.addCheckcast(data[i].substring(1));
                        code.addAstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case '[': {
                        code.addCheckcast(data[i]);
                        code.addAstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'I': {
                        Boxing.unboxInt(code);
                        code.addIstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'S': {
                        Boxing.unboxShort(code);
                        code.addIstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'B': {
                        Boxing.unboxByte(code);
                        code.addIstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'J': {
                        Boxing.unboxLong(code);
                        code.addLstore(varpos);
                        varpos += 2;
                        continue block14;
                    }
                    case 'F': {
                        Boxing.unboxFloat(code);
                        code.addFstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'D': {
                        Boxing.unboxDouble(code);
                        code.addDstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'C': {
                        Boxing.unboxChar(code);
                        code.addIstore(varpos);
                        ++varpos;
                        continue block14;
                    }
                    case 'Z': {
                        Boxing.unboxBoolean(code);
                        code.addIstore(varpos);
                        ++varpos;
                    }
                }
            }
            attribute.iterator().insert(0, code.get());
            return code.length();
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }
}

