/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip.data;

import org.fakereplace.manip.util.ClassLoaderFiltered;

public class VirtualToStaticData
implements ClassLoaderFiltered<VirtualToStaticData> {
    private final String oldClass;
    private final String newClass;
    private final String methodName;
    private final String newMethodName;
    private final String methodDesc;
    private final String newStaticMethodDesc;
    private final ClassLoader classLoader;

    public VirtualToStaticData(String oldClass, String newClass, String methodName, String methodDesc, String newStaticMethodDesc, String newMethodName, ClassLoader classLoader) {
        this.oldClass = oldClass;
        this.newClass = newClass;
        this.methodName = methodName;
        this.newMethodName = newMethodName == null ? methodName : newMethodName;
        this.methodDesc = methodDesc;
        this.newStaticMethodDesc = newStaticMethodDesc;
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oldClass);
        sb.append(" ");
        sb.append(this.newClass);
        sb.append(" ");
        sb.append(this.methodName);
        sb.append(" ");
        sb.append(this.methodDesc);
        sb.append(" ");
        sb.append(this.newStaticMethodDesc);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o.getClass().isAssignableFrom(VirtualToStaticData.class)) {
            VirtualToStaticData i = (VirtualToStaticData)o;
            return this.oldClass.equals(i.oldClass) && this.newClass.equals(i.newClass) && this.methodName.equals(i.methodName) && this.methodDesc.equals(i.methodDesc) && this.newStaticMethodDesc.equals(i.newStaticMethodDesc);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getOldClass() {
        return this.oldClass;
    }

    public String getNewClass() {
        return this.newClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getNewMethodName() {
        return this.newMethodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public String getNewStaticMethodDesc() {
        return this.newStaticMethodDesc;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public VirtualToStaticData getInstance() {
        return this;
    }
}

