/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.manip.ConstructorAccessManipulator;
import org.fakereplace.manip.ConstructorInvocationManipulator;
import org.fakereplace.manip.FieldAccessManipulator;
import org.fakereplace.manip.FinalMethodManipulator;
import org.fakereplace.manip.InstanceFieldManipulator;
import org.fakereplace.manip.MethodAccessManipulator;
import org.fakereplace.manip.MethodInvokationManipulator;
import org.fakereplace.manip.StaticFieldManipulator;
import org.fakereplace.manip.SubclassVirtualCallManipulator;
import org.fakereplace.manip.data.AddedFieldData;

public class Manipulator {
    private final MethodInvokationManipulator methodInvokationManipulator = new MethodInvokationManipulator();
    private final StaticFieldManipulator staticFieldManipulator = new StaticFieldManipulator();
    private final InstanceFieldManipulator instanceFieldManapulator = new InstanceFieldManipulator();
    private final ConstructorInvocationManipulator constructorInvocationManipulator = new ConstructorInvocationManipulator();
    private final ConstructorAccessManipulator constructorAccessManipulator = new ConstructorAccessManipulator();
    private final SubclassVirtualCallManipulator subclassVirtualCallManilulator = new SubclassVirtualCallManipulator();
    private final FinalMethodManipulator finalMethodManipulator = new FinalMethodManipulator();
    private final FieldAccessManipulator fieldAccessManipulator = new FieldAccessManipulator();
    private final MethodAccessManipulator methodAccessManipulator = new MethodAccessManipulator();
    private final Set<ClassManipulator> manipulators = new CopyOnWriteArraySet<ClassManipulator>();

    public Manipulator() {
        this.manipulators.add(this.methodInvokationManipulator);
        this.manipulators.add(this.staticFieldManipulator);
        this.manipulators.add(this.instanceFieldManapulator);
        this.manipulators.add(this.constructorInvocationManipulator);
        this.manipulators.add(this.subclassVirtualCallManilulator);
        this.manipulators.add(this.finalMethodManipulator);
        this.manipulators.add(this.fieldAccessManipulator);
        this.manipulators.add(this.methodAccessManipulator);
        this.manipulators.add(this.constructorAccessManipulator);
    }

    public void removeRewrites(String className, ClassLoader classLoader) {
        for (ClassManipulator m : this.manipulators) {
            m.clearRewrites(className, classLoader);
        }
    }

    public void rewriteStaticFieldAccess(String oldClass, String newClass, String fieldName, ClassLoader classLoader) {
        this.staticFieldManipulator.rewriteStaticFieldAccess(oldClass, newClass, fieldName, classLoader);
    }

    public void rewriteConstructorAccess(String clazz, String descriptor, int methodNo, ClassLoader classLoader) {
        this.constructorInvocationManipulator.rewriteConstructorCalls(clazz, descriptor, methodNo, classLoader);
    }

    public void rewriteInstanceFieldAccess(AddedFieldData data) {
        this.instanceFieldManapulator.addField(data);
    }

    public void rewriteSubclassCalls(String className, ClassLoader classLoader, String parentName, ClassLoader parentClassLoader, String methodName, String methodDesc) {
        this.subclassVirtualCallManilulator.addClassData(className, classLoader, parentName, parentClassLoader, methodName, methodDesc);
    }

    public void replaceVirtualMethodInvokationWithStatic(String oldClass, String newClass, String methodName, String methodDesc, String newStaticMethodDesc, ClassLoader classLoader) {
        this.methodInvokationManipulator.replaceVirtualMethodInvokationWithStatic(oldClass, newClass, methodName, methodDesc, newStaticMethodDesc, classLoader);
    }

    public void replaceVirtualMethodInvokationWithLocal(String oldClass, String methodName, String newMethodName, String methodDesc, String newStaticMethodDesc, ClassLoader classLoader) {
        this.methodInvokationManipulator.replaceVirtualMethodInvokationWithLocal(oldClass, methodName, newMethodName, methodDesc, newStaticMethodDesc, classLoader);
    }

    public boolean transformClass(ClassFile file, ClassLoader classLoader, boolean modifiable) {
        boolean modified = false;
        for (ClassManipulator m : this.manipulators) {
            if (!m.transformClass(file, classLoader, modifiable)) continue;
            modified = true;
        }
        return modified;
    }
}

