/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.manip.data.ConstructorRewriteData;
import org.fakereplace.manip.util.ManipulationDataStore;
import org.fakereplace.manip.util.ManipulationUtils;

public class ConstructorInvocationManipulator
implements ClassManipulator {
    private static final Logger log = Logger.getLogger(ConstructorInvocationManipulator.class);
    private final ManipulationDataStore<ConstructorRewriteData> data = new ManipulationDataStore();

    @Override
    public synchronized void clearRewrites(String className, ClassLoader loader) {
        this.data.remove(className, loader);
    }

    public void rewriteConstructorCalls(String clazz, String descriptor, int methodNo, ClassLoader classLoader) {
        ConstructorRewriteData d = new ConstructorRewriteData(clazz, descriptor, methodNo, classLoader);
        this.data.add(clazz, d);
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        Map<String, Set<ConstructorRewriteData>> constructorRewrites = this.data.getManipulationData(loader);
        if (constructorRewrites.isEmpty()) {
            return false;
        }
        HashMap<Integer, ConstructorRewriteData> methodCallLocations = new HashMap<Integer, ConstructorRewriteData>();
        Integer newCallLocation = null;
        ConstPool pool = file.getConstPool();
        block2: for (int i = 1; i < pool.getSize(); ++i) {
            if (pool.getTag(i) != 10 || !constructorRewrites.containsKey(pool.getMethodrefClassName(i))) continue;
            for (ConstructorRewriteData data : constructorRewrites.get(pool.getMethodrefClassName(i))) {
                if (!pool.getMethodrefName(i).equals("<init>") || !pool.getMethodrefType(i).equals(data.getMethodDesc())) continue;
                methodCallLocations.put(i, data);
                if (newCallLocation != null) continue block2;
                int classIndex = pool.getMethodrefClass(i);
                int newNameAndType = pool.addNameAndTypeInfo("<init>", "(I[Ljava/lang/Object;Lorg/fakereplace/ConstructorArgument;)V");
                newCallLocation = pool.addMethodrefInfo(classIndex, newNameAndType);
                continue block2;
            }
        }
        if (newCallLocation != null) {
            List methods = file.getMethods();
            for (MethodInfo m : methods) {
                try {
                    if (m.getCodeAttribute() == null) continue;
                    CodeIterator it = m.getCodeAttribute().iterator();
                    while (it.hasNext()) {
                        int val;
                        int index = it.next();
                        int op = it.byteAt(index);
                        if (op != 183 || !methodCallLocations.containsKey(val = it.s16bitAt(index + 1))) continue;
                        ConstructorRewriteData data = (ConstructorRewriteData)methodCallLocations.get(val);
                        it.writeByte(0, index);
                        it.writeByte(0, index + 1);
                        it.writeByte(0, index + 2);
                        Bytecode bc = new Bytecode(file.getConstPool());
                        ManipulationUtils.pushParametersIntoArray(bc, data.getMethodDesc());
                        bc.addIconst(data.getMethodNo());
                        bc.add(95);
                        bc.add(1);
                        bc.addInvokespecial(data.getClazz(), "<init>", "(I[Ljava/lang/Object;Lorg/fakereplace/ConstructorArgument;)V");
                        it.insert(bc.get());
                    }
                    m.getCodeAttribute().computeMaxStack();
                }
                catch (Exception e) {
                    log.error("Bad byte code transforming " + file.getName(), e);
                }
            }
            return true;
        }
        return false;
    }
}

