/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.logging;

import java.util.Arrays;
import java.util.Locale;
import org.fakereplace.AgentOption;
import org.fakereplace.AgentOptions;
import org.fakereplace.logging.Level;
import org.fakereplace.logging.LogManager;

class DefaultLogManager
implements LogManager {
    private final Level level;

    DefaultLogManager() {
        String levelString = AgentOptions.getOption(AgentOption.LOG);
        Level level = Level.INFO;
        if (levelString != null) {
            try {
                level = Level.valueOf(levelString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Could not find level " + levelString + " options are " + Arrays.asList(Level.values()));
            }
        }
        this.level = level;
    }

    @Override
    public void error(Class<?> category, String message) {
        System.out.println("[" + category.getName() + "] ERROR " + message);
    }

    @Override
    public void error(Class<?> category, String message, Throwable cause) {
        System.out.println("[" + category.getName() + "] ERROR " + message);
        cause.printStackTrace(System.err);
    }

    @Override
    public void info(Class<?> category, String message) {
        if (this.level.ordinal() <= Level.INFO.ordinal()) {
            System.out.println("[" + category.getName() + "] INFO " + message);
        }
    }

    @Override
    public void info(Class<?> category, String message, Throwable cause) {
        if (this.level.ordinal() <= Level.INFO.ordinal()) {
            System.out.println("[" + category.getName() + "] INFO " + message);
            cause.printStackTrace();
        }
    }

    @Override
    public void debug(Class<?> category, String message) {
        if (this.level.ordinal() <= Level.DEBUG.ordinal()) {
            System.out.println("[" + category.getName() + "] DEBUG " + message);
        }
    }

    @Override
    public void debug(Class<?> category, String message, Throwable cause) {
        if (this.level.ordinal() <= Level.DEBUG.ordinal()) {
            System.out.println("[" + category.getName() + "] DEBUG " + message);
            cause.printStackTrace();
        }
    }

    @Override
    public void trace(Class<?> category, String message) {
        if (this.level.ordinal() <= Level.TRACE.ordinal()) {
            System.out.println("[" + category.getName() + "] TRACE " + message);
        }
    }

    @Override
    public void trace(Class<?> category, String message, Throwable cause) {
        if (this.level.ordinal() <= Level.TRACE.ordinal()) {
            System.out.println("[" + category.getName() + "] TRACE " + message);
            cause.printStackTrace();
        }
    }
}

