/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.jbossas;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Set;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.boot.DefaultEnvironment;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.data.InstanceTracker;
import org.fakereplace.integration.jbossas.JBossAsEnvironment;
import org.fakereplace.logging.Logger;

public class ClassChangeNotifier
implements ClassChangeAware {
    private static final Logger log = Logger.getLogger(ClassChangeNotifier.class);

    public ClassChangeNotifier() {
        DefaultEnvironment.setEnvironment(new JBossAsEnvironment());
    }

    @Override
    public void beforeChange(Class<?>[] changed, ClassIdentifier[] added) {
    }

    @Override
    public void notify(Class<?>[] changed, ClassIdentifier[] added) {
        this.clearJSRResourceCache();
    }

    private void clearJSRResourceCache() {
        Set<?> caches = InstanceTracker.get("org.apache.naming.resources.ResourceCache");
        for (Object cache : caches) {
            try {
                Field field = cache.getClass().getDeclaredField("cache");
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                field.set(cache, Array.newInstance(fieldType.getComponentType(), 0));
            }
            catch (Exception e) {
                log.error("Failed to clear JSF resource cache", e);
                e.printStackTrace();
            }
        }
    }
}

