/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fakereplace.com.google.common.base.Function;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.data.BaseClassData;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.FieldData;
import org.fakereplace.data.MethodData;
import org.fakereplace.util.DescriptorUtils;

public class ClassData {
    private final String className;
    private final String internalName;
    private final Map<String, Map<String, Set<MethodData>>> methods = new MapMaker().makeMap();
    private final Map<Method, MethodData> methodsByMethod = new MapMaker().makeComputingMap(new MethodResolver());
    private final Map<String, FieldData> fields = new MapMaker().makeMap();
    private final Set<MethodData> methodSet = new HashSet<MethodData>();
    private final ClassLoader loader;
    private final String superClassName;
    private final boolean signitureModified;
    private final boolean replaceable;
    private static final MethodData NULL_METHOD_DATA = new MethodData("", "", "", null, 0, false);

    ClassData(BaseClassData data, Set<MethodData> addMethods, Set<MethodData> removedMethods, Set<FieldData> addedFields, Set<FieldData> removedFields) {
        this.className = data.getClassName();
        this.internalName = data.getInternalName();
        this.loader = data.getLoader();
        this.superClassName = data.getSuperClassName();
        this.signitureModified = removedFields.isEmpty() && removedMethods.isEmpty() && addedFields.isEmpty() && addMethods.isEmpty();
        this.replaceable = data.isReplaceable();
        for (MethodData m : data.getMethods()) {
            if (removedMethods.contains(m)) continue;
            this.addMethod(m);
        }
        for (FieldData f : data.getFields()) {
            if (removedFields.contains(f)) continue;
            this.addField(f);
        }
        for (FieldData f : removedFields) {
            this.addField(f);
        }
        for (FieldData f : addedFields) {
            this.addField(f);
        }
        for (MethodData m : removedMethods) {
            this.addMethod(m);
        }
        for (MethodData m : addMethods) {
            this.addMethod(m);
        }
        for (String nm : this.methods.keySet()) {
            for (String i : this.methods.get(nm).keySet()) {
                this.methodSet.addAll((Collection<MethodData>)this.methods.get(nm).get(i));
            }
        }
    }

    public MethodData getData(Method method) {
        MethodData res = this.methodsByMethod.get(method);
        if (res == NULL_METHOD_DATA) {
            return null;
        }
        return res;
    }

    ClassData(BaseClassData data) {
        this.className = data.getClassName();
        this.internalName = data.getInternalName();
        this.loader = data.getLoader();
        this.superClassName = data.getSuperClassName();
        this.replaceable = data.isReplaceable();
        for (MethodData m : data.getMethods()) {
            this.addMethod(m);
        }
        for (FieldData f : data.getFields()) {
            this.addField(f);
        }
        this.signitureModified = false;
    }

    public boolean isSignitureModified() {
        return this.signitureModified;
    }

    public ClassData getSuperClassInformation() {
        if (this.superClassName == null) {
            return null;
        }
        ClassData superClassInformation = ClassDataStore.instance().getModifiedClassData(this.loader, this.superClassName);
        for (ClassLoader l = this.loader; superClassInformation == null && l != null; l = l.getParent()) {
            superClassInformation = ClassDataStore.instance().getModifiedClassData(l, this.superClassName);
        }
        return superClassInformation;
    }

    public FieldData getField(String field) {
        return this.fields.get(field);
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void addMethod(MethodData data) {
        Map<String, Set<MethodData>> mts;
        if (!this.methods.containsKey(data.getMethodName())) {
            this.methods.put(data.getMethodName(), new HashMap());
        }
        if (!(mts = this.methods.get(data.getMethodName())).containsKey(data.getArgumentDescriptor())) {
            mts.put(data.getArgumentDescriptor(), new HashSet());
        }
        Set<MethodData> rr = mts.get(data.getArgumentDescriptor());
        rr.add(data);
    }

    public void replaceMethod(MethodData data) {
        if (!this.methods.containsKey(data.getMethodName())) {
            this.methods.put(data.getMethodName(), new HashMap());
        }
        Map<String, Set<MethodData>> mts = this.methods.get(data.getMethodName());
        HashSet<MethodData> rr = new HashSet<MethodData>();
        mts.put(data.getArgumentDescriptor(), rr);
        rr.add(data);
    }

    public void addField(FieldData data) {
        this.fields.put(data.getName(), data);
    }

    public Collection<MethodData> getMethods() {
        return this.methodSet;
    }

    public Collection<FieldData> getFields() {
        return this.fields.values();
    }

    public MethodData getMethodData(String name, String arguments) {
        Map<String, Set<MethodData>> r = this.methods.get(name);
        if (r == null) {
            return null;
        }
        Set<MethodData> ms = r.get(arguments);
        if (ms == null) {
            return null;
        }
        return ms.iterator().next();
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    private static class MethodResolver
    implements Function<Method, MethodData> {
        private MethodResolver() {
        }

        @Override
        public MethodData apply(Method from) {
            ClassData dta = ClassDataStore.instance().getModifiedClassData(from.getDeclaringClass().getClassLoader(), from.getDeclaringClass().getName());
            if (dta == null) {
                return NULL_METHOD_DATA;
            }
            String descriptor = DescriptorUtils.getDescriptor(from);
            for (MethodData m : dta.getMethods()) {
                if (!m.getMethodName().equals(from.getName()) || !descriptor.equals(m.getDescriptor())) continue;
                return m;
            }
            return NULL_METHOD_DATA;
        }
    }
}

