/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fakereplace.data.FieldData;
import org.fakereplace.data.MemberType;
import org.fakereplace.data.MethodData;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.Descriptor;
import org.fakereplace.javassist.bytecode.FieldInfo;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.util.DescriptorUtils;

public class BaseClassData {
    private final String className;
    private final String internalName;
    private final Set<MethodData> methods;
    private final Set<FieldData> fields;
    private final ClassLoader loader;
    private final String superClassName;
    private final boolean replaceable;

    public BaseClassData(ClassFile file, ClassLoader loader, boolean replaceable) {
        Object m;
        this.className = file.getName();
        this.replaceable = replaceable;
        this.internalName = Descriptor.toJvmName(file.getName());
        this.loader = loader;
        this.superClassName = file.getSuperclass();
        boolean finalMethod = false;
        HashSet<MethodData> meths = new HashSet<MethodData>();
        for (Object o : file.getMethods()) {
            String methodClassName = this.className;
            m = (MethodInfo)o;
            MemberType type = MemberType.NORMAL;
            if (((MethodInfo)m).getDescriptor().equals("(I[Ljava/lang/Object;)Ljava/lang/Object;") && ((MethodInfo)m).getName().equals("______REDEFINED_METHOD_DELEGATOR_$") || ((MethodInfo)m).getDescriptor().equals("(I[Ljava/lang/Object;)Ljava/lang/Object;") && ((MethodInfo)m).getName().equals("______REDEFINED_STATIC_METHOD_DELEGATOR_$") || ((MethodInfo)m).getDescriptor().equals("(I[Ljava/lang/Object;Lorg/fakereplace/ConstructorArgument;)V")) {
                type = MemberType.ADDED_SYSTEM;
            } else if (((MethodInfo)m).getAttribute("org.fakereplace.final") != null) {
                finalMethod = true;
            }
            MethodData md = new MethodData(((MethodInfo)m).getName(), ((MethodInfo)m).getDescriptor(), methodClassName, type, ((MethodInfo)m).getAccessFlags(), finalMethod);
            meths.add(md);
        }
        this.methods = Collections.unmodifiableSet(meths);
        HashSet<FieldData> fieldData = new HashSet<FieldData>();
        for (Object o : file.getFields()) {
            m = (FieldInfo)o;
            MemberType mt = MemberType.NORMAL;
            fieldData.add(new FieldData((FieldInfo)m, mt, this.className, ((FieldInfo)m).getAccessFlags()));
        }
        this.fields = Collections.unmodifiableSet(fieldData);
    }

    /*
     * WARNING - void declaration
     */
    public BaseClassData(Class<?> cls) {
        void var6_11;
        MethodData md;
        String descriptor;
        MemberType type;
        this.className = cls.getName();
        this.internalName = Descriptor.toJvmName(cls.getName());
        this.loader = cls.getClassLoader();
        this.replaceable = false;
        this.superClassName = cls.getSuperclass() != null ? cls.getSuperclass().getName() : null;
        HashSet<MethodData> meths = new HashSet<MethodData>();
        for (Method method : cls.getDeclaredMethods()) {
            type = MemberType.NORMAL;
            descriptor = DescriptorUtils.getDescriptor(method);
            if (descriptor.equals("(I[Ljava/lang/Object;)Ljava/lang/Object;") && method.getName().equals("______REDEFINED_METHOD_DELEGATOR_$") || descriptor.equals("(I[Ljava/lang/Object;)Ljava/lang/Object;") && method.getName().equals("______REDEFINED_STATIC_METHOD_DELEGATOR_$")) {
                type = MemberType.ADDED_SYSTEM;
            }
            md = new MethodData(method.getName(), descriptor, cls.getName(), type, method.getModifiers(), false);
            meths.add(md);
        }
        for (Executable executable : cls.getDeclaredConstructors()) {
            type = MemberType.NORMAL;
            descriptor = DescriptorUtils.getDescriptor(executable);
            if (descriptor.equals("(I[Ljava/lang/Object;Lorg/fakereplace/ConstructorArgument;)V")) {
                type = MemberType.ADDED_SYSTEM;
            }
            md = new MethodData("<init>", descriptor, cls.getName(), type, ((Constructor)executable).getModifiers(), false);
            meths.add(md);
        }
        this.methods = Collections.unmodifiableSet(meths);
        HashSet<FieldData> fieldData = new HashSet<FieldData>();
        Field[] arr$ = cls.getDeclaredFields();
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_11 < len$) {
            Field m = arr$[var6_11];
            fieldData.add(new FieldData(m));
            ++var6_11;
        }
        this.fields = Collections.unmodifiableSet(fieldData);
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Collection<MethodData> getMethods() {
        return this.methods;
    }

    public Collection<FieldData> getFields() {
        return this.fields;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }
}

