/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.annotation.Annotation;
import org.fakereplace.javassist.bytecode.annotation.AnnotationMemberValue;
import org.fakereplace.javassist.bytecode.annotation.ArrayMemberValue;
import org.fakereplace.javassist.bytecode.annotation.BooleanMemberValue;
import org.fakereplace.javassist.bytecode.annotation.ByteMemberValue;
import org.fakereplace.javassist.bytecode.annotation.CharMemberValue;
import org.fakereplace.javassist.bytecode.annotation.ClassMemberValue;
import org.fakereplace.javassist.bytecode.annotation.DoubleMemberValue;
import org.fakereplace.javassist.bytecode.annotation.EnumMemberValue;
import org.fakereplace.javassist.bytecode.annotation.FloatMemberValue;
import org.fakereplace.javassist.bytecode.annotation.IntegerMemberValue;
import org.fakereplace.javassist.bytecode.annotation.LongMemberValue;
import org.fakereplace.javassist.bytecode.annotation.MemberValue;
import org.fakereplace.javassist.bytecode.annotation.ShortMemberValue;
import org.fakereplace.javassist.bytecode.annotation.StringMemberValue;

public class AnnotationBuilder {
    public static Annotation createJavassistAnnotation(java.lang.annotation.Annotation annotation, ConstPool cp) {
        try {
            Annotation a = new Annotation(annotation.annotationType().getName(), cp);
            for (Method m : annotation.annotationType().getDeclaredMethods()) {
                Object val = m.invoke((Object)annotation, new Object[0]);
                a.addMemberValue(m.getName(), AnnotationBuilder.createMemberValue(m.getReturnType(), val, cp));
            }
            return a;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static MemberValue createMemberValue(Class<?> type, Object val, ConstPool cp) {
        if (type == Integer.TYPE) {
            return new IntegerMemberValue(cp, (Integer)val);
        }
        if (type == Short.TYPE) {
            return new ShortMemberValue((Short)val, cp);
        }
        if (type == Long.TYPE) {
            return new LongMemberValue((Long)val, cp);
        }
        if (type == Byte.TYPE) {
            return new ByteMemberValue((Byte)val, cp);
        }
        if (type == Float.TYPE) {
            return new FloatMemberValue(((Float)val).floatValue(), cp);
        }
        if (type == Double.TYPE) {
            return new DoubleMemberValue((Double)val, cp);
        }
        if (type == Character.TYPE) {
            return new CharMemberValue(((Character)val).charValue(), cp);
        }
        if (type == Boolean.TYPE) {
            return new BooleanMemberValue((Boolean)val, cp);
        }
        if (type == String.class) {
            return new StringMemberValue((String)val, cp);
        }
        if (type == Class.class) {
            return new ClassMemberValue(((Class)val).getName(), cp);
        }
        if (type.isEnum()) {
            EnumMemberValue e = new EnumMemberValue(cp);
            e.setType(type.getName());
            e.setValue(((Enum)val).name());
            return e;
        }
        if (type.isAnnotation()) {
            return new AnnotationMemberValue(AnnotationBuilder.createJavassistAnnotation((java.lang.annotation.Annotation)val, cp), cp);
        }
        if (type.isArray()) {
            Class<?> arrayType = type.getComponentType();
            int length = Array.getLength(val);
            MemberValue arrayval = AnnotationBuilder.createEmptyMemberValue(arrayType, cp);
            ArrayMemberValue ret = new ArrayMemberValue(arrayval, cp);
            MemberValue[] vals = new MemberValue[length];
            for (int i = 0; i < length; ++i) {
                vals[i] = AnnotationBuilder.createMemberValue(arrayType, Array.get(val, i), cp);
            }
            ret.setValue(vals);
            return ret;
        }
        throw new RuntimeException("Invalid array type " + type + " value: " + val);
    }

    private static MemberValue createEmptyMemberValue(Class<?> type, ConstPool cp) {
        if (type == Integer.TYPE) {
            return new IntegerMemberValue(cp);
        }
        if (type == Short.TYPE) {
            return new ShortMemberValue(cp);
        }
        if (type == Long.TYPE) {
            return new LongMemberValue(cp);
        }
        if (type == Byte.TYPE) {
            return new ByteMemberValue(cp);
        }
        if (type == Float.TYPE) {
            return new FloatMemberValue(cp);
        }
        if (type == Double.TYPE) {
            return new DoubleMemberValue(cp);
        }
        if (type == Character.TYPE) {
            return new CharMemberValue(cp);
        }
        if (type == Boolean.TYPE) {
            return new BooleanMemberValue(cp);
        }
        if (type == String.class) {
            return new StringMemberValue(cp);
        }
        if (type == Class.class) {
            return new ClassMemberValue(cp);
        }
        if (type.isEnum()) {
            EnumMemberValue e = new EnumMemberValue(cp);
            e.setType(type.getName());
            return e;
        }
        if (type.isAnnotation()) {
            AnnotationMemberValue a = new AnnotationMemberValue(cp);
            return a;
        }
        if (type.isArray()) {
            Class<?> arrayType = type.getComponentType();
            MemberValue arrayval = AnnotationBuilder.createEmptyMemberValue(arrayType, cp);
            ArrayMemberValue ret = new ArrayMemberValue(arrayval, cp);
            return ret;
        }
        throw new RuntimeException("Invalid array type " + type + " with no value ");
    }
}

