/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.com.google.common.collect;

import java.util.HashMap;
import java.util.Map;
import org.fakereplace.com.google.common.collect.ClassToInstanceMap;
import org.fakereplace.com.google.common.collect.ConstrainedMap;
import org.fakereplace.com.google.common.collect.ImmutableMap;
import org.fakereplace.com.google.common.collect.MapConstraint;

public final class MutableClassToInstanceMap<B>
extends ConstrainedMap<Class<? extends B>, B>
implements ClassToInstanceMap<B> {
    private static final MapConstraint<Class<?>, Object> VALUE_CAN_BE_CAST_TO_KEY = new MapConstraint<Class<?>, Object>(){

        @Override
        public void checkKeyValue(Class<?> key, Object value) {
            MutableClassToInstanceMap.cast(key, value);
        }
    };
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new ImmutableMap.Builder<Class<Boolean>, Class<Boolean>>().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();

    public static <B> MutableClassToInstanceMap<B> create() {
        return new MutableClassToInstanceMap(new HashMap());
    }

    public static <B> MutableClassToInstanceMap<B> create(Map<Class<? extends B>, B> backingMap) {
        return new MutableClassToInstanceMap<B>(backingMap);
    }

    private MutableClassToInstanceMap(Map<Class<? extends B>, B> delegate) {
        super(delegate, VALUE_CAN_BE_CAST_TO_KEY);
    }

    @Override
    public <T extends B> T putInstance(Class<T> type, T value) {
        return MutableClassToInstanceMap.cast(type, this.put(type, value));
    }

    @Override
    public <T extends B> T getInstance(Class<T> type) {
        return MutableClassToInstanceMap.cast(type, this.get(type));
    }

    static <B, T extends B> T cast(Class<T> type, B value) {
        return MutableClassToInstanceMap.wrap(type).cast(value);
    }

    private static <T> Class<T> wrap(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }
}

