/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.classloading;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.manip.util.MapFunction;

public class ProxyDefinitionStore {
    private static Map<ClassLoader, Map<String, byte[]>> proxyDefinitions = new MapMaker().weakKeys().makeComputingMap(new MapFunction(false));
    private static AtomicLong proxyNo = new AtomicLong();

    public static byte[] getProxyDefinition(ClassLoader classLoader, String name) {
        Map<String, byte[]> def = proxyDefinitions.get(classLoader);
        return def.get(name);
    }

    public static void saveProxyDefinition(ClassLoader classLoader, String className, byte[] data) {
        Map<String, byte[]> def = proxyDefinitions.get(classLoader);
        def.put(className, data);
    }

    public static String getProxyName() {
        return "org.fakereplace.proxies.ProxyClass" + proxyNo.incrementAndGet();
    }
}

