/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.boot;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.bind.JAXBContext;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.classloader.MaskingClassLoader;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.BootstrapFactory;
import org.fabric3.api.host.runtime.BootstrapHelper;
import org.fabric3.api.host.runtime.BootstrapService;
import org.fabric3.api.host.runtime.ComponentRegistration;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.RuntimeConfiguration;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.runtime.ScanResult;
import org.fabric3.api.host.runtime.ShutdownException;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.runtime.weblogic.api.Constants;
import org.fabric3.runtime.weblogic.boot.ServerMonitor;
import org.fabric3.runtime.weblogic.boot.WebLogicHiddenPackages;
import org.fabric3.runtime.weblogic.monitor.WebLogicDestinationRouter;
import org.fabric3.runtime.weblogic.work.WebLogicExecutorService;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public class Fabric3WebLogicListener
implements ServletContextListener {
    private static final String FABRIC3_HOME = "fabric3.home";
    private static final String FABRIC3_MODE = "fabric3.mode";
    private static final String FABRIC3_WEBLOGIC_HOST = "fabric3-weblogic-host";
    private static final int WLS_ACTIVATED_STATE = 2;
    private ServletContext context;
    private RuntimeCoordinator coordinator;
    private ServerMonitor monitor;

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.context = event.getServletContext();
            RuntimeMode runtimeMode = Fabric3WebLogicListener.getRuntimeMode();
            MBeanServer mBeanServer = this.getMBeanServer();
            ObjectName componentRuntime = this.getComponentRuntimeMBean(mBeanServer);
            String pathName = System.getProperty("fabric3.home");
            if (pathName == null) {
                event.getServletContext().log("fabric3.home system property not specified");
                return;
            }
            File installDirectory = new File(pathName);
            if (!installDirectory.exists()) {
                event.getServletContext().log("fabric3.home directory does not exist: " + pathName);
                return;
            }
            this.prepare(runtimeMode, mBeanServer, installDirectory, componentRuntime);
        }
        catch (JMException | NamingException e) {
            this.context.log("Error initializing Fabric3", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            if (this.coordinator == null) {
                return;
            }
            this.coordinator.shutdown();
            if (this.monitor != null) {
                this.monitor.stopped();
            }
        }
        catch (ShutdownException e) {
            this.context.log("Error shutting down Fabric3", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(RuntimeMode runtimeMode, MBeanServer mBeanServer, File installDirectory, ObjectName componentRuntime) {
        System.setProperty(JAXBContext.class.getName(), "com.sun.xml.bind.v2.ContextFactory");
        String vm = System.getProperty("java.vm.name");
        if (vm != null && vm.contains("IBM J9 VM")) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            System.setProperty("javax.xml.transform.TransformerFactory", "com.ibm.xtq.xslt.jaxp.compiler.TransformerFactoryImpl");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            String runtimeDirName;
            String runtimeName;
            if (RuntimeMode.CONTROLLER == runtimeMode) {
                String runtimeId = "controller";
                runtimeName = "controller";
                runtimeDirName = runtimeId;
            } else if (RuntimeMode.PARTICIPANT == runtimeMode) {
                String runtimeId;
                runtimeName = runtimeId = this.getRuntimeId(mBeanServer);
                runtimeDirName = "participant";
            } else {
                String runtimeId;
                runtimeName = runtimeId = this.getRuntimeId(mBeanServer);
                runtimeDirName = "vm";
            }
            File rootRuntimeDir = BootstrapHelper.getDirectory((File)installDirectory, (String)"runtimes");
            File runtimeDir = new File(rootRuntimeDir, runtimeDirName);
            File configDir = BootstrapHelper.getDirectory((File)runtimeDir, (String)"config");
            File extensionsDir = new File(installDirectory, "extensions");
            File bootDir = BootstrapHelper.getDirectory((File)installDirectory, (String)"boot");
            File hostDir = BootstrapHelper.getDirectory((File)installDirectory, (String)"host");
            ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
            MaskingClassLoader maskingClassLoader = new MaskingClassLoader(systemClassLoader, WebLogicHiddenPackages.getPackages(), true);
            ClassLoader hostLoader = BootstrapHelper.createClassLoader((ClassLoader)maskingClassLoader, (File)hostDir);
            ClassLoader bootLoader = BootstrapHelper.createClassLoader((ClassLoader)hostLoader, (File)bootDir);
            BootstrapService bootstrapService = BootstrapFactory.getService((ClassLoader)bootLoader);
            Document systemConfig = bootstrapService.loadSystemConfig(configDir);
            URI domainName = bootstrapService.parseDomainName(systemConfig);
            String environment = bootstrapService.parseEnvironment(systemConfig);
            List deployDirs = bootstrapService.parseDeployDirectories(systemConfig);
            HostInfo hostInfo = BootstrapHelper.createHostInfo((String)runtimeName, (String)"default.zone", (RuntimeMode)runtimeMode, (URI)domainName, (String)environment, (File)runtimeDir, (File)extensionsDir, (List)deployDirs, (boolean)true);
            FileHelper.cleanDirectory((File)hostInfo.getTempDir());
            WebLogicDestinationRouter destinationRouter = new WebLogicDestinationRouter();
            RuntimeConfiguration runtimeConfig = new RuntimeConfiguration(hostInfo, mBeanServer, (DestinationRouter)destinationRouter);
            Fabric3Runtime runtime = bootstrapService.createDefaultRuntime(runtimeConfig);
            Thread.currentThread().setContextClassLoader(hostLoader);
            Map exportedPackages = this.getExportedPackages();
            ScanResult result = bootstrapService.scanRepository(hostInfo);
            BootConfiguration configuration = new BootConfiguration();
            List registrations = bootstrapService.createDefaultRegistrations(runtime);
            WebLogicExecutorService executorService = new WebLogicExecutorService();
            ComponentRegistration executorRegistration = new ComponentRegistration("RuntimeThreadPoolExecutor", ExecutorService.class, (Object)executorService, true);
            registrations.add(executorRegistration);
            configuration.addRegistrations(registrations);
            configuration.setRuntime(runtime);
            configuration.setHostClassLoader(hostLoader);
            configuration.setBootClassLoader(bootLoader);
            configuration.setSystemConfig(systemConfig);
            configuration.setExtensionContributions(result.getExtensionContributions());
            configuration.setUserContributions(result.getUserContributions());
            configuration.setExportedPackages(exportedPackages);
            configuration.setHostCapabilities(this.getHostCapabilities());
            this.coordinator = bootstrapService.createCoordinator(configuration);
            this.coordinator.boot();
            this.coordinator.load();
            this.context.setAttribute("fabric3.runtime", (Object)runtime);
            MonitorProxyService monitorService = (MonitorProxyService)runtime.getComponent(MonitorProxyService.class, Names.MONITOR_FACTORY_URI);
            this.monitor = (ServerMonitor)monitorService.createMonitor(ServerMonitor.class);
            this.start(mBeanServer, componentRuntime, runtimeMode);
        }
        catch (Exception e) {
            this.context.log("Error initializing Fabric3", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void start(MBeanServer mBeanServer, ObjectName componentRuntime, RuntimeMode runtimeMode) {
        try {
            int state = (Integer)mBeanServer.getAttribute(componentRuntime, "DeploymentState");
            if (2 == state) {
                this.coordinator.joinDomain();
                this.monitor.started(runtimeMode.toString());
            } else {
                Executors.newSingleThreadExecutor().submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (JMException e) {
            this.monitor.errorMessage("Error retrieving deployment state. Federation disabled", (Throwable)e);
        }
    }

    private ObjectName getComponentRuntimeMBean(MBeanServer mBeanServer) throws JMException {
        ObjectName serverRuntime = (ObjectName)mBeanServer.getAttribute(Constants.WLS_RUNTIME_SERVICE_MBEAN, "ServerRuntime");
        ObjectName[] applicationRuntimes = (ObjectName[])mBeanServer.getAttribute(serverRuntime, "ApplicationRuntimes");
        ObjectName applicationRuntime = null;
        for (ObjectName runtime : applicationRuntimes) {
            if (!runtime.getKeyProperty("Name").contains("fabric3-weblogic-host")) continue;
            applicationRuntime = runtime;
            break;
        }
        if (applicationRuntime == null) {
            this.monitor.errorMessage("Application runtime MBean not found. Federation and cluster communication disabled.");
            return null;
        }
        ObjectName[] componentRuntimes = (ObjectName[])mBeanServer.getAttribute(applicationRuntime, "ComponentRuntimes");
        ObjectName componentRuntime = null;
        for (ObjectName runtime : componentRuntimes) {
            if (!runtime.getKeyProperty("ApplicationRuntime").contains("fabric3-weblogic-host")) continue;
            componentRuntime = runtime;
            break;
        }
        if (componentRuntime == null) {
            this.monitor.errorMessage("Component runtime MBean not found. Federation and cluster communication disabled.");
            return null;
        }
        return componentRuntime;
    }

    private Map<String, String> getExportedPackages() {
        HashMap<String, String> exportedPackages = new HashMap<String, String>();
        exportedPackages.put("org.fabric3.spi.*", "2.5.3");
        exportedPackages.put("com.bea.core.workmanager", "1.7.0.0");
        exportedPackages.put("com.bea.core.workmanager.internal", "1.7.0.0");
        exportedPackages.put("weblogic.common", "1.7.0.0");
        exportedPackages.put("weblogic.kernel", "1.7.0.0");
        exportedPackages.put("weblogic.work", "1.7.0.0");
        exportedPackages.put("weblogic.work.commonj", "1.7.0.0");
        exportedPackages.put("javax.jms", "1.1.0");
        exportedPackages.put("javax.transaction", "1.1.0");
        exportedPackages.put("javax.transaction.xa", "1.1.0");
        exportedPackages.put("org.fabric3.runtime.weblogic.api", "2.5.3");
        return exportedPackages;
    }

    private List<String> getHostCapabilities() {
        ArrayList<String> capabilities = new ArrayList<String>();
        capabilities.add("transaction");
        return capabilities;
    }

    private static RuntimeMode getRuntimeMode() {
        String mode = System.getProperty("fabric3.mode", "vm");
        if ("controller".equals(mode)) {
            return RuntimeMode.CONTROLLER;
        }
        if ("participant".equals(mode)) {
            return RuntimeMode.PARTICIPANT;
        }
        if (!"vm".equals(mode)) {
            throw new IllegalArgumentException("Invalid runtime mode: " + mode + ". Valid modes are 'controller', 'participant' or 'vm' (default).");
        }
        return RuntimeMode.VM;
    }

    private MBeanServer getMBeanServer() throws NamingException {
        InitialContext ctx = new InitialContext();
        return (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
    }

    public String getRuntimeId(MBeanServer mbServer) throws JMException {
        String[] path;
        Object current = Constants.WLS_RUNTIME_SERVICE_MBEAN;
        for (String token : path = new String[]{"ServerRuntime", "Name"}) {
            current = mbServer.getAttribute((ObjectName)current, token);
        }
        return (String)current;
    }

    static /* synthetic */ RuntimeCoordinator access$000(Fabric3WebLogicListener x0) {
        return x0.coordinator;
    }

    static /* synthetic */ ServerMonitor access$100(Fabric3WebLogicListener x0) {
        return x0.monitor;
    }
}

