/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gatein.integration.jboss.as7.deployment.GateInEarKey;
import org.gatein.integration.jboss.as7.deployment.GateInExtKey;
import org.gatein.integration.jboss.as7.deployment.PortletWarKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;

public class GateInConfiguration {
    private static final String DEPLOYMENT_SUFFIX = "deployment.";
    private Set<ModuleIdentifier> extModules = new HashSet<ModuleIdentifier>();
    private Set<ModuleDependency> portletWarDependencies = new LinkedHashSet<ModuleDependency>();
    private ModuleIdentifier earModule;
    private final List<ServiceName> childWars = new ArrayList<ServiceName>();
    private final List<ServiceName> childSubUnits = new ArrayList<ServiceName>();
    final ModuleLoader moduleLoader = Module.getBootModuleLoader();

    GateInConfiguration() {
    }

    public synchronized void addDeploymentArchive(String archive, boolean main) {
        String moduleId = DEPLOYMENT_SUFFIX + archive;
        this.extModules.add(ModuleIdentifier.create((String)moduleId));
        if (main) {
            this.earModule = ModuleIdentifier.create((String)moduleId);
        }
    }

    public synchronized void addPortletWarDependency(String dependency, boolean importSvcs) {
        String[] parts = GateInConfiguration.parseNameSlotPair(dependency);
        this.portletWarDependencies.add(new ModuleDependency(this.moduleLoader, ModuleIdentifier.create((String)parts[0], (String)parts[1]), false, false, importSvcs, true));
    }

    public synchronized Set<ModuleIdentifier> getGateInExtModules() {
        return Collections.unmodifiableSet(new HashSet<ModuleIdentifier>(this.extModules));
    }

    public synchronized Set<String> getGateInExtNames() {
        HashSet<String> ret = new HashSet<String>();
        for (ModuleIdentifier module : this.extModules) {
            ret.add(module.getName().substring(DEPLOYMENT_SUFFIX.length()));
        }
        return Collections.unmodifiableSet(ret);
    }

    public synchronized Set<ModuleDependency> getPortletWarDependencies() {
        return Collections.unmodifiableSet(new LinkedHashSet<ModuleDependency>(this.portletWarDependencies));
    }

    public ModuleIdentifier getGateInEarModule() {
        return this.earModule;
    }

    public synchronized String getGateInEarName() {
        return this.earModule != null ? this.earModule.getName().substring(DEPLOYMENT_SUFFIX.length()) : null;
    }

    public synchronized void clearDeploymentArchives() {
        this.earModule = null;
        this.extModules.clear();
    }

    public synchronized List<ServiceName> getChildWars() {
        return Collections.unmodifiableList(new ArrayList<ServiceName>(this.childWars));
    }

    public synchronized void addChildWar(ServiceName deploymentServiceName) {
        this.childWars.add(deploymentServiceName);
    }

    public synchronized List<ServiceName> getChildSubUnits() {
        return Collections.unmodifiableList(new ArrayList<ServiceName>(this.childSubUnits));
    }

    public synchronized List<String> getChildSubUnitComponentPrefixes() {
        LinkedList<String> ret = new LinkedList<String>();
        for (ServiceName name : this.childSubUnits) {
            ret.add(name.getCanonicalName() + ".component.");
        }
        return ret;
    }

    public synchronized void addChildSubUnit(ServiceName serviceName) {
        this.childSubUnits.add(serviceName);
    }

    private static String[] parseNameSlotPair(String name) {
        String[] parts = name.split(":");
        if (parts.length == 2) {
            return parts;
        }
        return new String[]{parts[0], null};
    }

    public static boolean isGateInArchive(DeploymentUnit du) {
        return du.getAttachment(GateInEarKey.KEY) != null || du.getAttachment(GateInExtKey.KEY) != null;
    }

    public static boolean isPortletArchive(DeploymentUnit du) {
        return du.getAttachment(PortletWarKey.INSTANCE) != null;
    }

    public static boolean isNonGateInPortletArchive(DeploymentUnit du) {
        return !GateInConfiguration.isGateInArchive(du) && GateInConfiguration.isPortletArchive(du);
    }

    public static boolean isGateInOrPortletArchive(DeploymentUnit du) {
        return GateInConfiguration.isGateInArchive(du) || GateInConfiguration.isPortletArchive(du);
    }
}

