/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashSet;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class DeploymentDirHandler {
    private static final Logger log = Logger.getLogger((String)"org.gatein");
    private static final String GATEIN_EAR = "gatein.ear";
    private static final PathElement SCANNER_GATEIN_PATH_ELEMENT = PathElement.pathElement((String)"scanner", (String)"gatein");
    private static final PathElement DEPLOYMENT_SCANNER_SUBSYSTEM_PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"deployment-scanner");
    private static final PathElement GATEIN_PATH_SUBSYSTEM_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"gatein");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleDeploymentDir(OperationContext context, GateInConfiguration config) {
        boolean hasGateInScanner = context.getRootResource().navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{DEPLOYMENT_SCANNER_SUBSYSTEM_PATH_ELEMENT})).hasChild(SCANNER_GATEIN_PATH_ELEMENT);
        if (hasGateInScanner) {
            String[] filesList;
            File absolute;
            ModelNode scannerModel = context.getRootResource().navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{DEPLOYMENT_SCANNER_SUBSYSTEM_PATH_ELEMENT, SCANNER_GATEIN_PATH_ELEMENT})).getModel();
            String path = scannerModel.get("path").asString();
            String relativeTo = scannerModel.get("relative-to").asString();
            if (relativeTo != null) {
                String propVal = System.getProperty(relativeTo);
                if (propVal == null) throw new IllegalStateException("Unresolvable relativeTo property of 'gatein' deployment-scanner: " + relativeTo);
                absolute = new File(propVal, path);
            } else {
                absolute = new File(path);
            }
            if ((filesList = absolute.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".war") || name.endsWith(".ear");
                }
            })) == null) {
                log.warn((Object)("'gatein' deployment-scanner directory (" + absolute + ") is empty. Looks like invalid configuration!"));
                filesList = new String[]{};
            }
            HashSet<String> filesSet = new HashSet<String>(Arrays.asList(filesList));
            String gateinEar = config.getGateInEarName();
            config.clearDeploymentArchives();
            if (gateinEar != null) {
                if (!filesSet.contains(gateinEar)) {
                    throw new IllegalStateException("The declared main archive (" + gateinEar + ") doesn't exist in " + absolute);
                }
            } else {
                gateinEar = GATEIN_EAR;
            }
            for (String name : filesSet) {
                config.addDeploymentArchive(name, name.equals(gateinEar));
            }
            log.info((Object)"Using 'gatein' deployment-scanner. Note that gatein subsystem <deployment-archives> section entries will be ignored except the one marked main='true'.");
            return;
        } else {
            log.warn((Object)"Separate deployment-scanner for 'gatein' not configured. Make sure to have gatein subsystem <deployment-archives> section properly configured.");
        }
    }
}

