/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.gatein.integration.jboss.as7;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;

import java.util.List;

import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.OP_ADDR;

/**
 * @author <a href="mailto:mstrukel@redhat.com">Marko Strukelj</a>
 */
public class DeploymentArchiveAdd extends AbstractAddStepHandler
{
   private GateInConfiguration config;

   DeploymentArchiveAdd(GateInConfiguration config)
   {
      this.config = config;
   }

   @Override
   protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException
   {
      DeploymentArchiveDefinition.MAIN.validateAndSet(operation,model);
   }

   @Override
   protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException
   {
      ModelNode addr = operation.get(OP_ADDR);
      if (!addr.hasDefined(1))
         throw new IllegalArgumentException("Invalid submodel address: " + addr);

      Property prop = addr.get(1).asProperty();
      if (!Constants.DEPLOYMENT_ARCHIVE.equals(prop.getName()))
         throw new IllegalArgumentException("Invalid submodel address: " + addr);

      ModelNode main = operation.get(Constants.MAIN);
      config.addDeploymentArchive(prop.getValue().asString(), main.isDefined() && main.asBoolean());
   }
}
