/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.sample.webui.component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.sample.webui.component.UISampleUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.ext.UIFormComboBox;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SearchUserActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class})})
public class UISampleUIForm
extends UIForm {
    private static final String[] ACTIONS = new String[]{"Save", "Reset"};
    public static final String USERNAME = "userName";
    public static final String PASSWORD = "password";
    public static final String FAVORITE_COLOR = "favoriteColor";
    public static final String POSITION = "position";
    public static final String RECEIVE_EMAIL = "receiveEmail";
    public static final String GENDER = "gender";
    private static final String DATE_OF_BIRTH = "dateOfBirth";
    private static final String DESCRIPTION = "description";
    private static final String COMBOBOX = "ComboBox";
    private List<String> userNames = new ArrayList();

    public UISampleUIForm() throws Exception {
        this.addUIFormInput((UIFormInputSet)this.makeUIFormInputWithActions());
        this.setActions(ACTIONS);
    }

    private UIFormInputWithActions makeUIFormInputWithActions() throws Exception {
        UIFormInputWithActions inputSet = new UIFormInputWithActions();
        this.addUIComponentToSet(inputSet);
        List searchUserAction = this.makeSearchUserActionData();
        inputSet.setActionField(USERNAME, searchUserAction);
        return inputSet;
    }

    private void addUIComponentToSet(UIFormInputWithActions inputSet) throws Exception {
        inputSet.addUIFormInput((UIFormInput)new UIFormStringInput(USERNAME, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        inputSet.addUIFormInput((UIFormInput)new UIFormStringInput(PASSWORD, null, null).setType((short)1));
        inputSet.addUIFormInput((UIFormInput)new UIFormColorPicker(FAVORITE_COLOR, null, UIFormColorPicker.Colors.N_RED));
        inputSet.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(GENDER, "Male", this.makeRadioOptions()).addValidator(MandatoryValidator.class, new Object[0]));
        inputSet.addUIFormInput((UIFormInput)new UIFormDateTimeInput(DATE_OF_BIRTH, null, new Date()));
        inputSet.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, null, ""));
        List selectItemOptions = this.makeSelectItemOptions();
        inputSet.addUIFormInput((UIFormInput)new UIFormSelectBox(POSITION, null, selectItemOptions));
        inputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(RECEIVE_EMAIL, null, (Object)"test"));
        ArrayList<SelectItemOption> comboBoxItemOptions = new ArrayList<SelectItemOption>();
        comboBoxItemOptions.add(new SelectItemOption((Object)"VI"));
        comboBoxItemOptions.add(new SelectItemOption((Object)"UK"));
        comboBoxItemOptions.add(new SelectItemOption((Object)"FR"));
        inputSet.addUIFormInput((UIFormInput)new UIFormComboBox(COMBOBOX, COMBOBOX, comboBoxItemOptions));
    }

    private List<SelectItemOption<String>> makeRadioOptions() {
        ArrayList<SelectItemOption<String>> selectItemOptions = new ArrayList<SelectItemOption<String>>();
        selectItemOptions.add(new SelectItemOption((Object)"Male"));
        selectItemOptions.add(new SelectItemOption((Object)"Female"));
        return selectItemOptions;
    }

    private List<SelectItemOption<String>> makeSelectItemOptions() {
        ArrayList<SelectItemOption<String>> selectItemOptions = new ArrayList<SelectItemOption<String>>();
        selectItemOptions.add(new SelectItemOption((Object)"Boss"));
        selectItemOptions.add(new SelectItemOption((Object)"Employee"));
        return selectItemOptions;
    }

    private List<UIFormInputWithActions.ActionData> makeSearchUserActionData() {
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData searchUser = new UIFormInputWithActions.ActionData();
        searchUser.setActionListener("SearchUser");
        searchUser.setActionType(0);
        searchUser.setActionName("SearchUser");
        searchUser.setCssIconClass("SearchIcon");
        actions.add(searchUser);
        return actions;
    }

    public boolean isUserExist(String userName) {
        return this.userNames.contains(userName);
    }

    public void saveUser(String userName) {
        this.userNames.add(userName);
    }
}

