/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdRnTo
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ftp.CmdRnTo");

    public CmdRnTo() {
        this.commandName = "RNTO";
    }

    public void run(String[] params) throws IOException {
        if (!"RNFR".equals(this.clientSession().getPrevCommand()) || this.clientSession().getPrevParamsEx() == null) {
            this.reply("503 Bad sequence of commands");
            return;
        }
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "RNTO"));
            return;
        }
        String pathName = params[1];
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(pathName);
            Session curSession = this.clientSession().getSession(newPath.get(0));
            String repoPath = this.clientSession().getRepoPath(newPath);
            if (curSession.itemExists(repoPath)) {
                this.reply(String.format("553 %s: Unable to rename file or directory", this.clientSession().getPrevParamsEx()));
                return;
            }
            curSession.move(this.clientSession().getPrevParamsEx(), repoPath);
            curSession.save();
            this.reply(String.format("250 %s command successful", "RNTO"));
            return;
        }
        catch (PathNotFoundException pexc) {
        }
        catch (NoSuchWorkspaceException wexc) {
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exceprion. " + exc.getMessage()), (Throwable)exc);
        }
        this.reply(String.format("550 %s: Permission denied", pathName));
    }
}

