/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdMkd
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger((String)"jcr.ftpservice.CmdMkd");

    public CmdMkd() {
        this.commandName = "MKD";
    }

    public void run(String[] params) throws IOException {
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "MKD"));
            return;
        }
        String srcPath = params[1];
        ArrayList<String> newPath = this.clientSession().getFullPath(srcPath);
        if (newPath.size() == 0) {
            this.reply(String.format("550 %s: Permission denied", srcPath));
            return;
        }
        try {
            Session curSession = this.clientSession().getSession(newPath.get(0));
            Node parentNode = curSession.getRootNode();
            for (int i = 1; i < newPath.size(); ++i) {
                String curPathName = newPath.get(i);
                parentNode = parentNode.hasNode(curPathName) ? parentNode.getNode(curPathName) : parentNode.addNode(curPathName, "nt:folder");
            }
            curSession.save();
            this.reply(String.format("257 \"%s\" directory created", srcPath));
            return;
        }
        catch (RepositoryException rexc) {
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        this.reply(String.format("550 %s: Permission denied", srcPath));
    }
}

