/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.client;

import org.exoplatform.applications.ooplugin.client.CommonProp;
import org.exoplatform.applications.ooplugin.client.PropApi;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Node;

public class PropManager {
    private static Log LOG = ExoLogger.getLogger(PropManager.class);
    protected static String[][] availableProperties = new String[][]{{"displayname", "org.exoplatform.applications.ooplugin.props.DisplayNameProp"}, {"resourcetype", "org.exoplatform.applications.ooplugin.props.ResourceTypeProp"}, {"getcontentlength", "org.exoplatform.applications.ooplugin.props.ContentLengthProp"}, {"getlastmodified", "org.exoplatform.applications.ooplugin.props.LastModifiedProp"}, {"version-name", "org.exoplatform.applications.ooplugin.props.VersionNameProp"}, {"creator-displayname", "org.exoplatform.applications.ooplugin.props.CreatorDisplayNameProp"}, {"creationdate", "org.exoplatform.applications.ooplugin.props.CreationDateProp"}};

    public static PropApi getPropertyByNode(Node propertyNode, String httpStatus) {
        try {
            String nodeName = propertyNode.getLocalName();
            if (!propertyNode.getNamespaceURI().equals("DAV:")) {
                nodeName = propertyNode.getNodeName();
            }
            PropApi curProp = null;
            for (int i = 0; i < availableProperties.length; ++i) {
                if (!nodeName.equals(availableProperties[i][0])) continue;
                curProp = (PropApi)Class.forName(availableProperties[i][1]).newInstance();
                break;
            }
            if (curProp == null) {
                curProp = new CommonProp(nodeName);
            }
            curProp.setStatus(httpStatus);
            curProp.init(propertyNode);
            return curProp;
        }
        catch (Exception exc) {
            LOG.info((Object)"Unhandled exception. ", (Throwable)exc);
            return null;
        }
    }
}

