/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.util.function.Function;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.MongoOperationClassReplacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public class CursorPreparerClassReplacement
extends MongoOperationClassReplacement {
    private static final CursorPreparerClassReplacement singleton = new CursorPreparerClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "org.springframework.data.mongodb.core.CursorPreparer";
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="initiateFind", usageFilter=UsageFilter.ANY, category=ReplacementCategory.MONGO, castTo="com.mongodb.client.FindIterable")
    public static Object initiateFind(Object preparer, @ThirdPartyCast(actualType="com.mongodb.client.MongoCollection") Object mongoCollection, Function<Object, Object> find) {
        return CursorPreparerClassReplacement.handleFind(mongoCollection, find);
    }

    private static Object handleFind(Object mongoCollection, Function<Object, Object> find) {
        long startTime = System.currentTimeMillis();
        Object argument = CursorPreparerClassReplacement.getField(find, "arg$1");
        Object query = CursorPreparerClassReplacement.getField(argument, "query");
        Object result = find.apply(mongoCollection);
        long endTime = System.currentTimeMillis();
        CursorPreparerClassReplacement.handleMongo(mongoCollection, query, true, endTime - startTime);
        return result;
    }
}

