/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex;

import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.GraphTransition;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.RegexGraph;

public class CostMatrix {
    private static final int DEL = 0;
    private static final int REP = 1;
    private static final int INS = 2;

    public static int calculateStandardCost(RegexGraph graph) {
        int ROWS = graph.getNumberOfRows();
        int COLUMNS = graph.getNumberOfColumns();
        double[][] matrix = new double[ROWS][COLUMNS];
        boolean FIRST_ROW = false;
        matrix[0][0] = 0.0;
        for (int col = 1; col < graph.getNumberOfColumns(); ++col) {
            double min = Double.MAX_VALUE;
            for (GraphTransition t : graph.getIncomingTransitions(0, col)) {
                int otherCol = graph.getColumn(t.fromState);
                if (col == otherCol) continue;
                double otherCost = matrix[0][otherCol];
                min = Math.min(min, CostMatrix.getSubPathCost(otherCost, Math.ceil(t.cost)));
            }
            matrix[0][col] = min;
        }
        for (int i = 1; i < ROWS; ++i) {
            for (int col = 0; col < COLUMNS; ++col) {
                matrix[i][col] = Double.MAX_VALUE;
                for (GraphTransition t : graph.getIncomingTransitions(i, col)) {
                    int otherCol = graph.getColumn(t.fromState);
                    int otherRow = t.fromRow;
                    if (!t.type.equals((Object)GraphTransition.TransitionType.PHANTOM)) {
                        matrix[i][col] = Math.min(matrix[i][col], CostMatrix.getSubPathCost(matrix[otherRow][otherCol], Math.ceil(t.cost)));
                        continue;
                    }
                    matrix[i][col] = Math.min(matrix[i][col], matrix[otherRow][otherCol]);
                }
            }
        }
        double min = matrix[ROWS - 1][COLUMNS - 1];
        return (int)Math.round(min);
    }

    public static double calculateCostForStringAVM(RegexGraph graph) {
        int ROWS = graph.getNumberOfRows();
        int COLUMNS = graph.getNumberOfColumns();
        double[][][] matrix = new double[ROWS][COLUMNS][3];
        CostMatrix.calculateInsertionCostOnFirstRow(graph, matrix);
        for (int i = 1; i < ROWS; ++i) {
            for (int col = 0; col < COLUMNS; ++col) {
                matrix[i][col][0] = Double.MAX_VALUE;
                matrix[i][col][1] = Double.MAX_VALUE;
                matrix[i][col][2] = Double.MAX_VALUE;
                Object object = graph.getIncomingTransitions(i, col).iterator();
                while (object.hasNext()) {
                    GraphTransition t = (GraphTransition)object.next();
                    int otherCol = graph.getColumn(t.fromState);
                    int otherRow = t.fromRow;
                    if (t.type.equals((Object)GraphTransition.TransitionType.INSERTION)) {
                        assert (otherRow == i);
                        matrix[i][col][2] = Math.min(matrix[i][col][2], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                        matrix[i][col][2] = Math.min(matrix[i][col][2], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][1], t.cost));
                        matrix[i][col][2] = Math.min(matrix[i][col][2], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][2], t.cost));
                        continue;
                    }
                    if (t.type.equals((Object)GraphTransition.TransitionType.REPLACEMENT)) {
                        matrix[i][col][1] = Math.min(matrix[i][col][1], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                        matrix[i][col][1] = Math.min(matrix[i][col][1], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][1], t.cost));
                        matrix[i][col][2] = Math.min(matrix[i][col][2], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                        matrix[i][col][2] = Math.min(matrix[i][col][2], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][1], t.cost));
                        continue;
                    }
                    if (t.type.equals((Object)GraphTransition.TransitionType.DELETION)) {
                        matrix[i][col][0] = Math.min(matrix[i][col][0], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                        matrix[i][col][1] = Math.min(matrix[i][col][1], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                        matrix[i][col][2] = Math.min(matrix[i][col][2], CostMatrix.getSubPathCost(matrix[otherRow][otherCol][0], t.cost));
                        continue;
                    }
                    if (!t.type.equals((Object)GraphTransition.TransitionType.PHANTOM)) continue;
                    assert (t.cost == 0.0);
                    matrix[i][col][0] = Math.min(matrix[i][col][0], matrix[otherRow][otherCol][0]);
                    matrix[i][col][1] = Math.min(matrix[i][col][1], matrix[otherRow][otherCol][1]);
                    matrix[i][col][2] = Math.min(matrix[i][col][2], matrix[otherRow][otherCol][2]);
                }
            }
        }
        double min = Double.MAX_VALUE;
        for (double value : matrix[ROWS - 1][COLUMNS - 1]) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    private static double getSubPathCost(double previousStateCost, double transitionCost) throws IllegalArgumentException {
        if (previousStateCost < 0.0) {
            throw new IllegalArgumentException("previousStateCost cannot be negative: " + previousStateCost);
        }
        if (transitionCost < 0.0) {
            throw new IllegalArgumentException("transitionCost cannot be negative: " + transitionCost);
        }
        if (previousStateCost == Double.MAX_VALUE || transitionCost == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        double sum = previousStateCost + transitionCost;
        if (sum < previousStateCost || sum < transitionCost) {
            return Double.MAX_VALUE;
        }
        return sum;
    }

    private static void calculateInsertionCostOnFirstRow(RegexGraph graph, double[][][] matrix) {
        boolean FIRST_ROW = false;
        matrix[0][0][0] = 0.0;
        matrix[0][0][1] = 0.0;
        matrix[0][0][2] = 0.0;
        for (int col = 1; col < graph.getNumberOfColumns(); ++col) {
            double min = Double.MAX_VALUE;
            for (GraphTransition t : graph.getIncomingTransitions(0, col)) {
                assert (t.type.equals((Object)GraphTransition.TransitionType.INSERTION) || t.type.equals((Object)GraphTransition.TransitionType.PHANTOM));
                assert (t.fromRow == 0);
                int otherCol = graph.getColumn(t.fromState);
                if (col == otherCol) continue;
                double otherCost = matrix[0][otherCol][2];
                min = Math.min(min, CostMatrix.getSubPathCost(otherCost, t.cost));
            }
            matrix[0][col][0] = Double.MAX_VALUE;
            matrix[0][col][1] = Double.MAX_VALUE;
            matrix[0][col][2] = min;
        }
    }
}

