/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.shared.ExternalServiceSharedUtils;

public class ExternalServiceInfo
implements Serializable {
    private final String remoteHostname;
    private final String protocol;
    private final Integer remotePort;

    public ExternalServiceInfo(String protocol, String remoteHostname, Integer remotePort) {
        this.protocol = protocol;
        this.remoteHostname = remoteHostname;
        this.remotePort = remotePort;
    }

    public String getHostname() {
        return this.remoteHostname;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public String signature() {
        return ExternalServiceSharedUtils.getSignature(this.protocol, this.remoteHostname, this.remotePort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalServiceInfo that = (ExternalServiceInfo)o;
        return Objects.equals(this.remoteHostname, that.remoteHostname) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.remotePort, that.remotePort);
    }

    public ExternalServiceInfo copy() {
        return new ExternalServiceInfo(this.protocol, this.remoteHostname, this.remotePort);
    }

    public int hashCode() {
        return Objects.hash(this.remoteHostname, this.protocol, this.remotePort);
    }
}

