/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.visitor.methodv;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementList;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementUtils;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;
import shaded.org.objectweb.asm.Type;

public class MethodReplacementMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private final boolean registerNewTargets;
    private final boolean isInSUT;
    private int currentLine;
    private int currentIndex;

    public MethodReplacementMethodVisitor(boolean registerNewTargets, boolean isInSUT, MethodVisitor mv, String className, String methodName, String descriptor) {
        super(589824, mv);
        this.className = className;
        this.methodName = methodName;
        this.registerNewTargets = registerNewTargets;
        this.isInSUT = isInSUT;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.methodName.equals("<clinit>")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (opcode == 183 && !name.equals("<init>")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        boolean isConstructor = name.equals("<init>");
        List<MethodReplacementClass> candidateClasses = ReplacementList.getReplacements(owner, isConstructor);
        if (candidateClasses.isEmpty()) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Optional<Method> r = ReplacementUtils.chooseMethodFromCandidateReplacement(this.isInSUT, name, desc, candidateClasses, false, this.className);
        if (!r.isPresent()) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        this.handleLastCallerClass();
        Method m = r.get();
        this.replaceMethod(m);
        if (isConstructor) {
            this.handleConstruct(m, candidateClasses.get(0).getClass());
        }
        String debugInfo = "";
        Replacement a = m.getAnnotation(Replacement.class);
        if (a.type() == ReplacementType.TRACKER) {
            UnitsInfoRecorder.markNewTrackedMethod(debugInfo);
        } else if (this.isInSUT) {
            UnitsInfoRecorder.markNewReplacedMethodInSut(debugInfo);
        } else {
            UnitsInfoRecorder.markNewReplacedMethodInThirdParty(debugInfo);
        }
    }

    private void handleLastCallerClass() {
        this.visitLdcInsn(this.className);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "setLastCallerClass", "(Ljava/lang/String;)V", ExecutionTracer.class.isInterface());
    }

    private void handleConstruct(Method m, Class<? extends MethodReplacementClass> mrc) {
        this.visitInsn(88);
        if (!Arrays.stream(mrc.getDeclaredMethods()).anyMatch(it -> it.getName().equals("consumeInstance"))) {
            throw new RuntimeException("Class " + mrc.getName() + " must have a definition of method " + "consumeInstance");
        }
        Method consumeInstance = Arrays.stream(mrc.getDeclaredMethods()).filter(it -> it.getName().equals("consumeInstance")).findFirst().get();
        this.mv.visitMethodInsn(184, Type.getInternalName(consumeInstance.getDeclaringClass()), consumeInstance.getName(), Type.getMethodDescriptor(consumeInstance), false);
        Replacement br = m.getAnnotation(Replacement.class);
        assert (br.replacingConstructor());
        if (!br.castTo().isEmpty()) {
            this.mv.visitTypeInsn(192, ClassName.get(br.castTo()).getBytecodeName());
        }
    }

    private void replaceMethod(Method m) {
        Replacement br = m.getAnnotation(Replacement.class);
        if (br.type() != ReplacementType.TRACKER) {
            if (this.registerNewTargets) {
                String idTemplate = ObjectiveNaming.methodReplacementObjectiveNameTemplate(this.className, this.currentLine, this.currentIndex);
                ++this.currentIndex;
                String idTrue = ObjectiveNaming.methodReplacementObjectiveName(idTemplate, true, br.type());
                String idFalse = ObjectiveNaming.methodReplacementObjectiveName(idTemplate, false, br.type());
                ObjectiveRecorder.registerTarget(idTrue);
                ObjectiveRecorder.registerTarget(idFalse);
                this.visitLdcInsn(idTemplate);
            } else {
                this.visitInsn(1);
            }
        }
        this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m), false);
        if (!br.castTo().isEmpty() && !br.replacingConstructor()) {
            this.mv.visitTypeInsn(192, ClassName.get(br.castTo()).getBytecodeName());
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 1, maxLocals);
    }
}

