/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex;

public class RegexUtils {
    public static boolean isSupportedRegex(String regex) {
        return !regex.contains("\\b");
    }

    public static String expandRegex(String regex) {
        String newRegex = regex.replaceAll("\\\\d", "[0-9]");
        newRegex = newRegex.replaceAll("\\\\D", "[^0-9]");
        newRegex = newRegex.replaceAll("\\\\s", " ");
        newRegex = newRegex.replaceAll("\\\\S", "[a-zA-Z_0-9]");
        newRegex = newRegex.replaceAll("\\\\w", "[a-zA-Z_0-9]");
        if ((newRegex = newRegex.replaceAll("\\\\W", "[^a-zA-Z_0-9]")).startsWith("^")) {
            newRegex = newRegex.substring(1);
        }
        if (newRegex.endsWith("$")) {
            newRegex = newRegex.substring(0, newRegex.length() - 1);
        }
        newRegex = RegexUtils.removeFlagExpressions(newRegex);
        newRegex = RegexUtils.removeReluctantOperators(newRegex);
        return newRegex;
    }

    private static String removeFlagExpressions(String regex) {
        regex = regex.replaceAll("\\(\\?i\\)", "");
        regex = regex.replaceAll("\\(\\?d\\)", "");
        regex = regex.replaceAll("\\(\\?x\\)", "");
        regex = regex.replaceAll("\\(\\?m\\)", "");
        regex = regex.replaceAll("\\(\\?s\\)", "");
        regex = regex.replaceAll("\\(\\?u\\)", "");
        return regex;
    }

    private static String removeReluctantOperators(String regex) {
        regex = regex.replaceAll("\\+\\?", "\\+");
        regex = regex.replaceAll("\\*\\?", "\\*");
        regex = regex.replaceAll("\\?\\?", "\\?");
        return regex;
    }
}

