/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class BooleanClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Boolean.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, replacingStatic=true, category=ReplacementCategory.BASE)
    public static boolean parseBoolean(String input, String idTemplate) {
        Truthness t;
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.BOOLEAN, null));
        }
        if (idTemplate == null) {
            return Boolean.parseBoolean(input);
        }
        boolean res = Boolean.parseBoolean(input);
        if (res) {
            t = new Truthness(1.0, 0.1);
        } else if (input == null) {
            t = new Truthness(0.05, 1.0);
        } else {
            double base = 0.1;
            long distance = DistanceHelper.getLeftAlignmentDistance(input.toLowerCase(), "true");
            double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return res;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true, category=ReplacementCategory.BASE)
    public static Boolean valueOf(String input, String idTemplate) {
        return BooleanClassReplacement.parseBoolean(input, idTemplate);
    }
}

