/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.HostnameResolutionInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.InetAddressClassReplacement;
import org.evomaster.client.java.instrumentation.shared.IPAddressValidator;
import org.evomaster.client.java.instrumentation.shared.PreDefinedSSLInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.MethodReplacementPreserveSemantics;

public class ExternalServiceUtils {
    public static final String canonicalLocalHostname = InetAddress.getLoopbackAddress().getCanonicalHostName();

    public static boolean isValidIP(String s) {
        if (IPAddressValidator.isValidInet4Address(s)) {
            return true;
        }
        return IPAddressValidator.isValidInet6Address(s);
    }

    public static void analyzeDnsResolution(String host) {
        if (ExternalServiceUtils.skipHostnameOrIp(host)) {
            return;
        }
        try {
            InetAddress addresses = InetAddressClassReplacement.getByName(host);
            ExecutionTracer.addHostnameInfo(new HostnameResolutionInfo(host, addresses.getHostAddress()));
        }
        catch (Exception e) {
            ExecutionTracer.addHostnameInfo(new HostnameResolutionInfo(host, null));
        }
    }

    public static String[] collectExternalServiceInfo(ExternalServiceInfo remoteHostInfo, int remotePort) {
        ExecutionTracer.addExternalServiceHost(remoteHostInfo);
        if (!ExecutionTracer.hasLocalAddressForHost(remoteHostInfo.getHostname())) {
            return new String[]{ExecutionTracer.getDefaultSinkholeAddress(), "" + remotePort};
        }
        return new String[]{ExecutionTracer.getLocalAddress(remoteHostInfo.getHostname()), "" + remotePort};
    }

    public static boolean skipHostnameOrIp(String hostname) {
        return hostname == null || hostname.isEmpty() || ExternalServiceUtils.skipHostname(hostname) || hostname.startsWith("0.") || hostname.startsWith("10.") || hostname.startsWith("192.168.") || hostname.startsWith("127.") && !ExecutionTracer.hasMappingForLocalAddress(hostname);
    }

    public static boolean skipHostname(String hostname) {
        return hostname == null || hostname.isEmpty() || hostname.equals("localhost") || hostname.equals("docker.socket") || hostname.equals(canonicalLocalHostname);
    }

    public static int inferPort(int port, String protocol) {
        if (port >= 0) {
            return port;
        }
        switch (protocol) {
            case "https": {
                return 443;
            }
            case "http": {
                return 80;
            }
        }
        return port;
    }

    public static URL getReplacedURL(URL url) {
        if (MethodReplacementPreserveSemantics.shouldPreserveSemantics) {
            return url;
        }
        URL replacedURL = url;
        if ((url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) && !ExternalServiceUtils.skipHostnameOrIp(url.getHost()) && !ExecutionTracer.skipHostnameAndPort(url.getHost(), url.getPort())) {
            int port = ExternalServiceUtils.inferPort(url.getPort(), url.getProtocol());
            ExternalServiceUtils.analyzeDnsResolution(url.getHost());
            if (url.getProtocol().equalsIgnoreCase("https")) {
                PreDefinedSSLInfo.setTrustAllForHttpsURLConnection();
            }
            ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo(url.getProtocol(), url.getHost(), port);
            String[] ipAndPort = ExternalServiceUtils.collectExternalServiceInfo(remoteHostInfo, port);
            String urlString = url.getProtocol() + "://" + ipAndPort[0] + ":" + ipAndPort[1] + url.getPath();
            if (url.getQuery() != null) {
                urlString = urlString + "?" + url.getQuery();
            }
            try {
                replacedURL = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return replacedURL;
    }
}

