/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.object;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ClassToSchema {
    private static final Map<Type, String> cache = new ConcurrentHashMap<Type, String>();

    public static String getOrDeriveSchema(Class<?> klass) {
        return ClassToSchema.getOrDeriveSchema(klass.getName(), klass);
    }

    public static String getOrDeriveSchema(String name, Type type) {
        if (cache.containsKey(type)) {
            return ClassToSchema.named(name, cache.get(type));
        }
        String schema = ClassToSchema.getSchema(type);
        cache.put(type, schema);
        return ClassToSchema.named(name, schema);
    }

    private static String named(String name, String jsonObject) {
        return "\"" + name + "\":" + jsonObject;
    }

    private static String getSchema(Type type) {
        Class klass = null;
        if (type instanceof Class) {
            klass = (Class)type;
        }
        ParameterizedType pType = null;
        if (type instanceof ParameterizedType) {
            pType = (ParameterizedType)type;
        }
        if (klass != null) {
            if (String.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string");
            }
            if (Byte.class.isAssignableFrom(klass) || Byte.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int8");
            }
            if (Short.class.isAssignableFrom(klass) || Short.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int16");
            }
            if (Integer.class.isAssignableFrom(klass) || Integer.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int32");
            }
            if (Long.class.isAssignableFrom(klass) || Long.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int64");
            }
            if (Float.class.isAssignableFrom(klass) || Float.TYPE == klass) {
                return ClassToSchema.fieldSchema("number", "float");
            }
            if (Double.class.isAssignableFrom(klass) || Double.TYPE == klass) {
                return ClassToSchema.fieldSchema("number", "double");
            }
            if (Boolean.class.isAssignableFrom(klass) || Boolean.TYPE == klass) {
                return ClassToSchema.fieldSchema("boolean");
            }
        }
        if (klass != null && (klass.isArray() || List.class.isAssignableFrom(klass) || Set.class.isAssignableFrom(klass)) || pType != null && (List.class.isAssignableFrom((Class)pType.getRawType()) || Set.class.isAssignableFrom((Class)pType.getRawType()))) {
            return ClassToSchema.fieldArraySchema(klass, pType);
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (Class target = klass; target != null; target = target.getSuperclass()) {
            for (Field f : target.getDeclaredFields()) {
                if (!ClassToSchema.shouldAddToSchema(f)) continue;
                String fieldName = ClassToSchema.getName(f);
                properties.add(ClassToSchema.getOrDeriveSchema(fieldName, f.getGenericType()));
            }
        }
        return ClassToSchema.fieldObjectSchema(properties);
    }

    private static boolean shouldAddToSchema(Field field) {
        if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        for (Annotation a : field.getAnnotations()) {
            String name = a.annotationType().getSimpleName();
            if (!name.equalsIgnoreCase("Ignore") && !name.equalsIgnoreCase("Ignored") && !name.equalsIgnoreCase("Exclude") && !name.equalsIgnoreCase("Excluded") && !name.equalsIgnoreCase("JsonIgnore") && !name.equalsIgnoreCase("Skip") && !name.equalsIgnoreCase("Transient")) continue;
            return false;
        }
        return true;
    }

    private static String getName(Field field) {
        for (Annotation a : field.getAnnotations()) {
            String name = a.annotationType().getName();
            if (!name.equals("com.fasterxml.jackson.annotation.JsonProperty") && !name.equals("com.google.gson.annotations.SerializedName")) continue;
            try {
                Method m = a.annotationType().getMethod("value", new Class[0]);
                String value = (String)m.invoke((Object)a, new Object[0]);
                if (value == null || value.isEmpty()) continue;
                return value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return field.getName();
    }

    private static String fieldArraySchema(Class<?> klass, ParameterizedType pType) {
        String item;
        if (klass != null) {
            item = klass.isArray() ? ClassToSchema.getSchema(klass.getComponentType()) : ClassToSchema.getSchema(String.class);
        } else {
            Type generic = pType.getActualTypeArguments()[0];
            item = ClassToSchema.getSchema(generic);
        }
        return "{\"type\":\"array\", \"items\":" + item + "}";
    }

    private static String fieldObjectSchema(List<String> properties) {
        String p = properties.stream().collect(Collectors.joining(","));
        return "{\"type\":\"object\", \"properties\": {" + p + "}}";
    }

    private static String fieldSchema(String type) {
        return "{\"type\":\"" + type + "\"}";
    }

    private static String fieldSchema(String type, String format) {
        return "{\"type\":\"" + type + "\", \"format\":\"" + format + "\"}";
    }
}

