/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.StatementClassReplacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.utils.SimpleLogger;

public class PreparedStatementClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return PreparedStatement.class;
    }

    public static String extractSqlFromH2PreparedStatement(PreparedStatement stmt) {
        Class<?> klass = stmt.getClass();
        String className = klass.getName();
        if (!className.equals("org.h2.jdbc.JdbcPreparedStatement")) {
            throw new IllegalArgumentException("Invalid type: " + className);
        }
        try {
            Field cf = klass.getDeclaredField("command");
            cf.setAccessible(true);
            Object command = cf.get(stmt);
            Class<?> ck = command.getClass();
            if (!ck.getName().endsWith("CommandRemote")) {
                ck = ck.getSuperclass();
            }
            Field sf = ck.getDeclaredField("sql");
            sf.setAccessible(true);
            String sql = (String)sf.get(command);
            Method pm = command.getClass().getDeclaredMethod("getParameters", new Class[0]);
            pm.setAccessible(true);
            List pv = (List)pm.invoke(command, new Object[0]);
            List<String> params = pv.stream().map(it -> {
                try {
                    Method gpvm = it.getClass().getDeclaredMethod("getParamValue", new Class[0]);
                    gpvm.setAccessible(true);
                    Object value = gpvm.invoke(it, new Object[0]);
                    if (value.getClass().getName().equals("org.h2.value.ValueLobDb")) {
                        return "LOB";
                    }
                    return value.toString();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            return PreparedStatementClassReplacement.interpolateSqlStringWithJSqlParser(sql, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String interpolateSqlString(String sql, List<String> params) {
        long replacements = sql.chars().filter(it -> it == 63).count();
        if (replacements != (long)params.size()) {
            SimpleLogger.error("EvoMaster ERROR. Mismatch of parameter count " + replacements + "!=" + params.size() + " in SQL command: " + sql);
            return null;
        }
        for (String p : params) {
            sql = sql.replaceFirst("\\?", p);
        }
        return sql;
    }

    public static String interpolateSqlStringWithJSqlParser(String sql, final List<String> params) {
        StringBuilder sqlbuffer = new StringBuilder();
        try {
            ExpressionDeParser expDeParser = new ExpressionDeParser(){

                @Override
                public void visit(JdbcParameter parameter) {
                    int index = parameter.getIndex();
                    this.getBuffer().append((String)params.get(index - 1));
                }
            };
            SelectDeParser selectDeparser = new SelectDeParser(expDeParser, sqlbuffer);
            expDeParser.setSelectVisitor(selectDeparser);
            expDeParser.setBuffer(sqlbuffer);
            StatementDeParser stmtDeparser = new StatementDeParser(expDeParser, selectDeparser, sqlbuffer);
            Statement stmt = CCJSqlParserUtil.parse(sql);
            stmt.accept(stmtDeparser);
            return stmtDeparser.getBuffer().toString();
        }
        catch (Exception e) {
            SimpleLogger.error("EvoMaster ERROR. Could not handle " + sql + " with an error message :" + e.getMessage());
            return sql;
        }
    }

    private static String handlePreparedStatement(PreparedStatement stmt) {
        if (stmt == null) {
            return null;
        }
        String fullClassName = stmt.getClass().getName();
        if (fullClassName.startsWith("com.zaxxer.hikari.pool") || fullClassName.startsWith("org.apache.tomcat.jdbc.pool") || fullClassName.startsWith("com.sun.proxy") || PreparedStatementClassReplacement.checkZebraPreparedStatementWrapper(fullClassName)) {
            return null;
        }
        String sql = stmt.toString();
        if (sql.startsWith("com.mysql")) {
            sql = sql.substring(sql.indexOf(":") + 1);
        }
        if (stmt.getClass().getName().equals("org.h2.jdbc.JdbcPreparedStatement")) {
            sql = PreparedStatementClassReplacement.extractSqlFromH2PreparedStatement(stmt);
        }
        if (fullClassName.startsWith("com.dianping.zebra")) {
            throw new IllegalArgumentException("unsupported type for zebra: " + fullClassName);
        }
        return sql;
    }

    private static boolean checkZebraPreparedStatementWrapper(String className) {
        return className.equals("com.dianping.zebra.group.jdbc.GroupPreparedStatement") || className.equals("com.dianping.zebra.shard.jdbc.ShardPreparedStatement") || className.equals("com.dianping.zebra.single.jdbc.SinglePreparedStatement");
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
        String sql = PreparedStatementClassReplacement.handlePreparedStatement(stmt);
        return StatementClassReplacement.executeSql(() -> stmt.executeQuery(), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static int executeUpdate(PreparedStatement stmt) throws SQLException {
        String sql = PreparedStatementClassReplacement.handlePreparedStatement(stmt);
        return StatementClassReplacement.executeSql(() -> stmt.executeUpdate(), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static boolean execute(PreparedStatement stmt) throws SQLException {
        String sql = PreparedStatementClassReplacement.handlePreparedStatement(stmt);
        return StatementClassReplacement.executeSql(() -> stmt.execute(), sql);
    }
}

