/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ObjectsClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Objects.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, replacingStatic=true, category=ReplacementCategory.BASE)
    public static boolean equals(Object left, Object right, String idTemplate) {
        Truthness t;
        if (left instanceof String && right instanceof String) {
            ExecutionTracer.handleTaintForStringEquals((String)left, (String)right, false);
        }
        boolean result = Objects.equals(left, right);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else if (left == null || right == null) {
            t = new Truthness(0.05, 1.0);
        } else {
            double base = 0.1;
            double distance = DistanceHelper.getDistance(left, right);
            double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }
}

