/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Base64;
import java.util.Objects;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.RegexDistanceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class Base64DecoderClassReplacement
implements MethodReplacementClass {
    private static final String BASE64_REGEX = "^([A-Za-z0-9\\+/]{4})*([A-Za-z0-9\\+/]{4}|[A-Za-z0-9\\+/]{3}=|[A-Za-z0-9\\+/]{2}==)$";

    @Override
    public Class<?> getTargetClass() {
        return Base64.Decoder.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, category=ReplacementCategory.EXT_0)
    public static byte[] decode(Base64.Decoder caller, String src, String idTemplate) {
        Objects.requireNonNull(caller);
        if (src != null && ExecutionTracer.isTaintInput(src)) {
            ExecutionTracer.addStringSpecialization(src, new StringSpecializationInfo(StringSpecialization.REGEX_WHOLE, BASE64_REGEX));
        }
        if (idTemplate == null) {
            return caller.decode(src);
        }
        try {
            byte[] res = caller.decode(src);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (IllegalArgumentException ex) {
            double distance = RegexDistanceUtils.getStandardDistance(src, BASE64_REGEX);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0 / (1.0 + distance), 1.0));
            throw ex;
        }
    }
}

