/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.net.InetAddress;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.HostnameResolutionInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.InetAddressClassReplacement;
import org.evomaster.client.java.instrumentation.shared.ExternalServiceSharedUtils;
import org.evomaster.client.java.instrumentation.shared.IPAddressValidator;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ExternalServiceInfoUtils {
    public static boolean isValidIP(String s) {
        if (IPAddressValidator.isValidInet4Address(s)) {
            return true;
        }
        return IPAddressValidator.isValidInet6Address(s);
    }

    public static void analyzeDnsResolution(String host) {
        try {
            InetAddress addresses = InetAddressClassReplacement.getByName(host);
            ExecutionTracer.addHostnameInfo(new HostnameResolutionInfo(host, addresses.getHostAddress()));
        }
        catch (Exception e) {
            ExecutionTracer.addHostnameInfo(new HostnameResolutionInfo(host, null));
        }
    }

    public static String[] collectExternalServiceInfo(ExternalServiceInfo remoteHostInfo, int remotePort) {
        ExecutionTracer.addExternalServiceHost(remoteHostInfo);
        String signature = remoteHostInfo.signature();
        if (!ExecutionTracer.hasMockServerForHostname(remoteHostInfo.getHostname())) {
            int connectPort = remotePort;
            if (!ExecutionTracer.hasActiveExternalMappingForSignature(signature)) {
                ExecutionTracer.addEmployedDefaultWMHost(remoteHostInfo);
                signature = ExternalServiceSharedUtils.getWMDefaultSignature(remoteHostInfo.getProtocol(), remotePort);
                connectPort = ExternalServiceSharedUtils.getDefaultWMPort(signature);
            }
            return new String[]{ExecutionTracer.getExternalMappingForSignature(signature), "" + connectPort};
        }
        return new String[]{ExecutionTracer.getExternalMappingForHostname(remoteHostInfo.getHostname()), "" + remotePort};
    }

    public static boolean skipHostnameOrIp(String hostname) {
        return hostname.isEmpty() || hostname.startsWith("localhost") || hostname.startsWith("0.") || hostname.startsWith("10.") || hostname.startsWith("192.168.") || hostname.startsWith("docker.socket") || hostname.startsWith("127.") && !ExecutionTracer.hasMappingForLocalAddress(hostname);
    }

    public static int inferPort(int port, String protocol) {
        if (port >= 0) {
            return port;
        }
        switch (protocol) {
            case "https": {
                return 443;
            }
            case "http": {
                return 80;
            }
        }
        return port;
    }
}

