/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.JpaConstraint;
import org.evomaster.client.java.instrumentation.JpaConstraintBuilder;
import org.evomaster.client.java.instrumentation.NameSpace;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassAnalyzer {
    private static final List<String> JAKARTA_PERSISTENCE_LAYER_NAMES = Arrays.asList("jakarta.persistence.Entity", "jakarta.validation.constraints.NotNull");
    private static final List<String> JAVAX_NAMES = Arrays.asList("javax.persistence.Entity", "javax.validation.constraints.NotNull");

    public static void doAnalyze(Collection<String> classNames) {
        boolean canUseJavaPersistenceApi = ClassAnalyzer.canUseJavaxJPA();
        boolean canUseJakartaPersistenceLayer = canUseJavaPersistenceApi ? false : ClassAnalyzer.canUseJakartaPersistenceLayer();
        for (String name : classNames) {
            Class<?> klass;
            try {
                ClassLoader loader = UnitsInfoRecorder.getInstance().getFirstClassLoader(name);
                if (loader == null) {
                    loader = ClassAnalyzer.class.getClassLoader();
                    SimpleLogger.warn("No class loader registered for " + name);
                }
                klass = loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                SimpleLogger.error("Failed to load class " + name, e);
                continue;
            }
            try {
                if (!canUseJavaPersistenceApi && !canUseJakartaPersistenceLayer) continue;
                NameSpace namespace = canUseJavaPersistenceApi ? NameSpace.JAVAX : NameSpace.JAKARTA;
                Objects.requireNonNull(namespace);
                ClassAnalyzer.analyzeConstraints(klass, namespace);
            }
            catch (Exception e) {
                SimpleLogger.error("Failed to analyze " + name, e);
            }
        }
    }

    private static boolean canUseJavaxJPA() {
        boolean canUseJavaxJPA = ClassAnalyzer.classesCanBeLoaded(JAVAX_NAMES);
        if (!canUseJavaxJPA) {
            SimpleLogger.info("Not analyzing JPA using javax package");
        }
        return canUseJavaxJPA;
    }

    private static boolean canUseJakartaPersistenceLayer() {
        boolean canUseJakartaPersistenceLayer = ClassAnalyzer.classesCanBeLoaded(JAKARTA_PERSISTENCE_LAYER_NAMES);
        if (!canUseJakartaPersistenceLayer) {
            SimpleLogger.info("Failed to load Jakarta Persistence Layer classes");
        }
        return canUseJakartaPersistenceLayer;
    }

    private static boolean classesCanBeLoaded(List<String> classNamesToBeLoaded) {
        try {
            ClassLoader loader = UnitsInfoRecorder.getInstance().getSutClassLoader();
            if (loader == null) {
                SimpleLogger.warn("No identified ClassLoader for SUT");
                loader = ClassAnalyzer.class.getClassLoader();
            }
            for (String className : classNamesToBeLoaded) {
                loader.loadClass(className);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Annotation getAnnotationByName(Class<?> klass, String name) {
        return ClassAnalyzer.getAnnotationByName(klass.getAnnotations(), name);
    }

    private static Annotation getAnnotationByName(Field field, String name) {
        return ClassAnalyzer.getAnnotationByName(field.getAnnotations(), name);
    }

    private static Annotation getAnnotationByName(Annotation[] annotations, String name) {
        return Arrays.stream(annotations).filter(a -> a.annotationType().getName().equals(name)).findFirst().orElse(null);
    }

    private static String convertToSnakeCase(String s) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        return s.replaceAll(regex, replacement).toLowerCase();
    }

    private static void analyzeConstraints(Class<?> klass, NameSpace namespace) throws Exception {
        Annotation entityAnnotation = ClassAnalyzer.getEntityAnnotation(klass, namespace);
        if (entityAnnotation == null) {
            return;
        }
        String entityName = (String)entityAnnotation.getClass().getMethod("name", new Class[0]).invoke((Object)entityAnnotation, new Object[0]);
        Annotation tableAnnotation = ClassAnalyzer.getTableAnnotation(klass, namespace);
        String tableName = tableAnnotation != null ? (String)tableAnnotation.getClass().getMethod("name", new Class[0]).invoke((Object)tableAnnotation, new Object[0]) : (entityName != null && !entityName.isEmpty() ? entityName : klass.getSimpleName());
        tableName = ClassAnalyzer.convertToSnakeCase(tableName);
        for (Field f : klass.getDeclaredFields()) {
            JpaConstraint jpaConstraint;
            if (Modifier.isStatic(f.getModifiers()) || ClassAnalyzer.getTransientAnnotation(f, namespace) != null) continue;
            String columnName = null;
            Annotation columnAnnotation = ClassAnalyzer.getColumnAnnotation(f, namespace);
            if (columnAnnotation != null) {
                columnName = (String)columnAnnotation.getClass().getMethod("name", new Class[0]).invoke((Object)columnAnnotation, new Object[0]);
            }
            if (columnName == null || columnName.isEmpty()) {
                columnName = f.getName();
            }
            if (!(jpaConstraint = ClassAnalyzer.buildJpaConstraint(namespace, f, tableName, columnName)).isMeaningful()) continue;
            UnitsInfoRecorder.registerNewJpaConstraint(jpaConstraint);
        }
    }

    private static JpaConstraint buildJpaConstraint(NameSpace namespace, Field f, String tableName, String columnName) throws Exception {
        Objects.requireNonNull(namespace);
        return new JpaConstraintBuilder().withTableName(tableName).withColumnName(ClassAnalyzer.convertToSnakeCase(columnName)).withIsNullable(ClassAnalyzer.isNullableAnnotation(f, namespace)).withMinValue(ClassAnalyzer.getMinValue(f, namespace)).withMaxValue(ClassAnalyzer.getMaxValue(f, namespace)).withEnumValuesAsStrings(ClassAnalyzer.getEnumeratedAnnotation(f, namespace)).withDecimalMinValue(ClassAnalyzer.getDecimalMinValue(f, namespace)).withDecimalMaxValue(ClassAnalyzer.getDecimalMaxValue(f, namespace)).withIsNotBlank(ClassAnalyzer.isNotBlank(f, namespace)).withIsEmail(ClassAnalyzer.isEmail(f, namespace)).withIsNegative(ClassAnalyzer.isNegative(f, namespace)).withIsNegativeOrZero(ClassAnalyzer.isNegativeOrZero(f, namespace)).withIsPositive(ClassAnalyzer.isPositive(f, namespace)).withIsPositiveOrZero(ClassAnalyzer.isPositiveOrZero(f, namespace)).withIsFuture(ClassAnalyzer.isFuture(f, namespace)).withIsFutureOrPresent(ClassAnalyzer.isFutureOrPresent(f, namespace)).withIsPast(ClassAnalyzer.isPast(f, namespace)).withIsPastOrPresent(ClassAnalyzer.isPastOrPresent(f, namespace)).withIsAlwaysNull(ClassAnalyzer.isAlwaysNull(f, namespace)).withPatternRegExp(ClassAnalyzer.getPatterRegExp(f, namespace)).withSizeMin(ClassAnalyzer.getSizeMin(f, namespace)).withSizeMax(ClassAnalyzer.getSizeMax(f, namespace)).withDigitsInteger(ClassAnalyzer.getDigitsInteger(f, namespace)).withDigitsFraction(ClassAnalyzer.getDigitsFraction(f, namespace)).createJpaConstraint();
    }

    private static Annotation getColumnAnnotation(Field f, NameSpace namespace) {
        String columnAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.persistence.Column", "jakarta.persistence.Column");
        return ClassAnalyzer.getAnnotationByName(f, columnAnnotationName);
    }

    private static Annotation getTransientAnnotation(Field f, NameSpace namespace) {
        String transientAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.persistence.Transient", "jakarta.persistence.Transient");
        return ClassAnalyzer.getAnnotationByName(f, transientAnnotationName);
    }

    private static Annotation getTableAnnotation(Class<?> klass, NameSpace namespace) {
        String tableAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.persistence.Table", "jakarta.persistence.Table");
        return ClassAnalyzer.getAnnotationByName(klass, tableAnnotationName);
    }

    private static Annotation getEntityAnnotation(Class<?> klass, NameSpace namespace) {
        String entityAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.persistence.Entity", "jakarta.persistence.Entity");
        return ClassAnalyzer.getAnnotationByName(klass, entityAnnotationName);
    }

    private static Long getMaxValue(Field f, NameSpace namespace) throws Exception {
        String maxAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Max", "jakarta.validation.constraints.Max");
        return ClassAnalyzer.getLongElement(f, maxAnnotationName);
    }

    private static Long getMinValue(Field f, NameSpace namespace) throws Exception {
        String minAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Min", "jakarta.validation.constraints.Min");
        return ClassAnalyzer.getLongElement(f, minAnnotationName);
    }

    private static String getDecimalMinValue(Field f, NameSpace namespace) throws Exception {
        String decimalMinAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.DecimalMin", "jakarta.validation.constraints.DecimalMin");
        return ClassAnalyzer.getStringElement(f, decimalMinAnnotationName, "value");
    }

    private static String getDecimalMaxValue(Field f, NameSpace namespace) throws Exception {
        String decimalMaxAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.DecimalMax", "jakarta.validation.constraints.DecimalMax");
        return ClassAnalyzer.getStringElement(f, decimalMaxAnnotationName, "value");
    }

    private static String getPatterRegExp(Field f, NameSpace namespace) throws Exception {
        String patternAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Pattern", "jakarta.validation.constraints.Pattern");
        return ClassAnalyzer.getStringElement(f, patternAnnotationName, "regexp");
    }

    private static String getAnnotationName(NameSpace namespace, String javaxAnnotationName, String jakartaAnnotationName) {
        switch (namespace) {
            case JAVAX: {
                Objects.requireNonNull(javaxAnnotationName);
                assert (javaxAnnotationName.startsWith("javax."));
                return javaxAnnotationName;
            }
            case JAKARTA: {
                Objects.requireNonNull(jakartaAnnotationName);
                assert (jakartaAnnotationName.startsWith("jakarta."));
                return jakartaAnnotationName;
            }
        }
        throw new IllegalArgumentException("Unsupported namespace " + (Object)((Object)namespace));
    }

    private static Long getLongElement(Field f, String annotationName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Long)ClassAnalyzer.getElement(f, annotationName, "value");
    }

    private static String getStringElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (String)ClassAnalyzer.getElement(f, annotationName, elementName);
    }

    private static Integer getIntegerElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Integer)ClassAnalyzer.getElement(f, annotationName, elementName);
    }

    private static Integer getSizeMin(Field f, NameSpace namespace) throws Exception {
        String sizeAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Size", "jakarta.validation.constraints.Size");
        return ClassAnalyzer.getIntegerElement(f, sizeAnnotationName, "min");
    }

    private static Integer getSizeMax(Field f, NameSpace namespace) throws Exception {
        String sizeAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Size", "jakarta.validation.constraints.Size");
        return ClassAnalyzer.getIntegerElement(f, sizeAnnotationName, "max");
    }

    private static Integer getDigitsInteger(Field f, NameSpace namespace) throws Exception {
        String digitsAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Digits", "jakarta.validation.constraints.Digits");
        return ClassAnalyzer.getIntegerElement(f, digitsAnnotationName, "integer");
    }

    private static Integer getDigitsFraction(Field f, NameSpace namespace) throws Exception {
        String digitsAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Digits", "jakarta.validation.constraints.Digits");
        return ClassAnalyzer.getIntegerElement(f, digitsAnnotationName, "fraction");
    }

    private static Object getElement(Field f, String annotationName, String elementName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Annotation annotation = ClassAnalyzer.getAnnotationByName(f, annotationName);
        if (annotation != null) {
            return annotation.getClass().getMethod(elementName, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        return null;
    }

    private static List<String> getEnumeratedAnnotation(Field f, NameSpace namespace) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String enumeratedAnnotationName;
        Annotation enumerated;
        List enumValuesAsStrings = null;
        if (f.getType().isEnum() && (enumerated = ClassAnalyzer.getAnnotationByName(f, enumeratedAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.persistence.Enumerated", "jakarta.persistence.Enumerated"))) != null) {
            Object enumeratedValue = enumerated.getClass().getMethod("value", new Class[0]).invoke((Object)enumerated, new Object[0]);
            String enumTypeString = "STRING".toLowerCase();
            if (enumeratedValue.toString().toLowerCase().equals(enumTypeString)) {
                enumValuesAsStrings = Arrays.stream(f.getType().getEnumConstants()).map(Object::toString).collect(Collectors.toList());
            }
        }
        return enumValuesAsStrings;
    }

    private static Boolean isNullableAnnotation(Field f, NameSpace namespace) {
        String notNullAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.NotNull", "jakarta.validation.constraints.NotNull");
        if (f.getType().isPrimitive() || ClassAnalyzer.getAnnotationByName(f, notNullAnnotationName) != null) {
            return false;
        }
        return null;
    }

    private static Boolean isNotBlank(Field f, NameSpace namespace) {
        String notBlankAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.NotBlank", "jakarta.validation.constraints.NotBlank");
        return ClassAnalyzer.getIsAnnotationWith(f, notBlankAnnotationName);
    }

    private static Boolean isEmail(Field f, NameSpace namespace) {
        String emailAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Email", "jakarta.validation.constraints.Email");
        return ClassAnalyzer.getIsAnnotationWith(f, emailAnnotationName);
    }

    private static Boolean isPositive(Field f, NameSpace namespace) {
        String positiveAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Positive", "jakarta.validation.constraints.Positive");
        return ClassAnalyzer.getIsAnnotationWith(f, positiveAnnotationName);
    }

    private static Boolean isPositiveOrZero(Field f, NameSpace namespace) {
        String positiveOrZeroAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.PositiveOrZero", "jakarta.validation.constraints.PositiveOrZero");
        return ClassAnalyzer.getIsAnnotationWith(f, positiveOrZeroAnnotationName);
    }

    private static Boolean isNegative(Field f, NameSpace namespace) {
        String negativeAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Negative", "jakarta.validation.constraints.Negative");
        return ClassAnalyzer.getIsAnnotationWith(f, negativeAnnotationName);
    }

    private static Boolean isNegativeOrZero(Field f, NameSpace namespace) {
        String negativeOrZeroAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.NegativeOrZero", "jakarta.validation.constraints.NegativeOrZero");
        return ClassAnalyzer.getIsAnnotationWith(f, negativeOrZeroAnnotationName);
    }

    private static Boolean isPast(Field f, NameSpace namespace) {
        String pastAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Past", "jakarta.validation.constraints.Past");
        return ClassAnalyzer.getIsAnnotationWith(f, pastAnnotationName);
    }

    private static Boolean isPastOrPresent(Field f, NameSpace namespace) {
        String pastOrPresentAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.PastOrPresent", "jakarta.validation.constraints.PastOrPresent");
        return ClassAnalyzer.getIsAnnotationWith(f, pastOrPresentAnnotationName);
    }

    private static Boolean isFuture(Field f, NameSpace namespace) {
        String futureAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Future", "jakarta.validation.constraints.Future");
        return ClassAnalyzer.getIsAnnotationWith(f, futureAnnotationName);
    }

    private static Boolean isFutureOrPresent(Field f, NameSpace namespace) {
        String futureOrPresentAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.FutureOrPresent", "jakarta.validation.constraints.FutureOrPresent");
        return ClassAnalyzer.getIsAnnotationWith(f, futureOrPresentAnnotationName);
    }

    private static Boolean isAlwaysNull(Field f, NameSpace namespace) {
        String nullAnnotationName = ClassAnalyzer.getAnnotationName(namespace, "javax.validation.constraints.Null", "jakarta.validation.constraints.Null");
        return ClassAnalyzer.getIsAnnotationWith(f, nullAnnotationName);
    }

    private static Boolean getIsAnnotationWith(Field f, String annotationName) {
        Boolean isAnnotated = ClassAnalyzer.getAnnotationByName(f, annotationName) != null ? Boolean.valueOf(true) : null;
        return isAnnotated;
    }
}

