/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.instrumentation.ExternalService;
import org.evomaster.client.java.instrumentation.ExternalServiceMapping;

public class Action
implements Serializable {
    private final int index;
    private final String name;
    private final Set<String> inputVariables;
    private final Map<String, ExternalServiceMapping> externalServiceMapping;
    private final Map<String, String> localAddressMapping;
    private final List<ExternalService> skippedExternalServices;

    public Action(int index, String name, Collection<String> inputVariables, Map<String, ExternalServiceMapping> externalServiceMapping, Map<String, String> localAddressMapping, List<ExternalService> skippedExternalServices) {
        this.index = index;
        this.name = name;
        this.inputVariables = Collections.unmodifiableSet(new HashSet<String>(inputVariables));
        this.externalServiceMapping = Collections.unmodifiableMap(new HashMap<String, ExternalServiceMapping>(externalServiceMapping));
        this.localAddressMapping = Collections.unmodifiableMap(new HashMap<String, String>(localAddressMapping));
        this.skippedExternalServices = Collections.unmodifiableList(new ArrayList<ExternalService>(skippedExternalServices));
    }

    public int getIndex() {
        return this.index;
    }

    public Set<String> getInputVariables() {
        return this.inputVariables;
    }

    public Map<String, ExternalServiceMapping> getExternalServiceMapping() {
        return this.externalServiceMapping;
    }

    public Map<String, String> getLocalAddressMapping() {
        return this.localAddressMapping;
    }

    public List<ExternalService> getSkippedExternalServices() {
        return this.skippedExternalServices;
    }

    public String getName() {
        return this.name;
    }
}

