/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;
import org.evomaster.client.java.controller.problem.rpc.schema.params.IntParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.DateType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;

public class UtilDateType
extends DateType {
    public final boolean EMPLOY_SIMPLE_Format;

    public UtilDateType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec, List<IntParam> dateFields, boolean simpleFormat) {
        super(type, fullTypeName, clazz, spec, dateFields);
        this.EMPLOY_SIMPLE_Format = simpleFormat;
    }

    public UtilDateType(String type, String fullTypeName, Class<?> clazz, boolean simpleFormat, JavaDtoSpec spec) {
        super(type, fullTypeName, clazz, spec);
        this.EMPLOY_SIMPLE_Format = simpleFormat;
        List<IntParam> dateFields = null;
        dateFields = simpleFormat ? Arrays.asList(this.year, this.month, this.day, this.hour, this.minute, this.second) : Arrays.asList(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond, this.timezone);
        this.setDateFields(dateFields);
    }

    public UtilDateType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec, boolean employSimpleFormat) {
        this(type, fullTypeName, clazz, employSimpleFormat, spec);
    }

    public UtilDateType(JavaDtoSpec spec, boolean employSimpleFormat) {
        this(Date.class.getSimpleName(), Date.class.getName(), Date.class, spec, employSimpleFormat);
    }

    public UtilDateType(JavaDtoSpec spec) {
        this(Date.class.getSimpleName(), Date.class.getName(), Date.class, spec, true);
    }

    @Override
    public String getDateString(List<IntParam> values) {
        if (values.size() != this.getDateFields().size()) {
            throw new RuntimeException("mismatched size of values, it should be " + this.getDateFields().size() + ", but it is " + values.size());
        }
        if (this.EMPLOY_SIMPLE_Format) {
            return String.format("%04d-%02d-%02d %02d:%02d:%02d", values.get(0).getValue(), values.get(1).getValue(), values.get(2).getValue(), values.get(3).getValue(), values.get(4).getValue(), values.get(5).getValue());
        }
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d %s", values.get(0).getValue(), values.get(1).getValue(), values.get(2).getValue(), values.get(3).getValue(), values.get(4).getValue(), values.get(5).getValue(), values.get(6).getValue(), this.formatZZZZ((Integer)values.get(7).getValue()));
    }

    @Override
    public Date getDateInstance(List<IntParam> values) {
        String stringValue = this.getDateString(values);
        try {
            if (this.EMPLOY_SIMPLE_Format) {
                return SIMPLE_DATE_FORMATTER.parse(stringValue);
            }
            return DATE_FORMATTER.parse(stringValue);
        }
        catch (ParseException e) {
            throw new RuntimeException("ERROR: fail to parse values to Date");
        }
    }

    @Override
    public List<IntParam> getIntValues(Object date) {
        if (!(date instanceof Date)) {
            throw new IllegalArgumentException("cannot handle the object instance which is not java.util.Date");
        }
        String stringValue = DATE_FORMATTER.format(date);
        String[] strValues = stringValue.split(" ");
        if (strValues.length != 3) {
            throw new IllegalArgumentException("invalid a string for specifying a date:" + stringValue);
        }
        List<IntParam> values = this.getDateFields().stream().map(x -> (IntParam)x.copyStructureWithProperties()).collect(Collectors.toList());
        String[] dateValues = strValues[0].split("-");
        if (dateValues.length != 3) {
            throw new IllegalArgumentException("invalid a string for specifying a date:" + strValues[0]);
        }
        ((IntParam)values.get(0)).setValue(Integer.parseInt(dateValues[0]));
        ((IntParam)values.get(1)).setValue(Integer.parseInt(dateValues[1]));
        ((IntParam)values.get(2)).setValue(Integer.parseInt(dateValues[2]));
        String[] timeValues = strValues[1].split(":");
        if (timeValues.length != 3) {
            throw new IllegalArgumentException("invalid a string for specifying a time:" + strValues[1]);
        }
        ((IntParam)values.get(3)).setValue(Integer.parseInt(timeValues[0]));
        ((IntParam)values.get(4)).setValue(Integer.parseInt(timeValues[1]));
        String[] secondValue = timeValues[2].split("\\.");
        if (secondValue.length != 2) {
            throw new IllegalArgumentException("invalid a string for specifying seconds:" + strValues[2]);
        }
        ((IntParam)values.get(5)).setValue(Integer.parseInt(secondValue[0]));
        if (!this.EMPLOY_SIMPLE_Format) {
            values.get(6).setValue(Integer.parseInt(secondValue[1]));
            values.get(7).setValue(Integer.parseInt(strValues[2]));
        }
        return values;
    }

    @Override
    public long getDateLong(List<IntParam> values) {
        return ((Date)this.getDateInstance((List)values)).getTime();
    }

    @Override
    public TypeDto getDto() {
        TypeDto dto = super.getDto();
        dto.depth = this.depth;
        dto.type = RPCSupportedDataType.UTIL_DATE;
        return dto;
    }

    @Override
    public UtilDateType copy() {
        return new UtilDateType(this.spec, this.EMPLOY_SIMPLE_Format);
    }
}

