/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;

public abstract class TypeSchema {
    private final String simpleTypeName;
    private final String fullTypeName;
    private final Class<?> clazz;
    public final JavaDtoSpec spec;
    private Class<?> originalType;
    public int depth;

    public TypeSchema(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec) {
        this.simpleTypeName = type;
        this.fullTypeName = fullTypeName;
        this.clazz = clazz;
        this.spec = spec;
    }

    public void setOriginalType(Class<?> originalType) {
        this.originalType = originalType;
    }

    public String getSimpleTypeName() {
        return this.simpleTypeName;
    }

    public String getFullTypeName() {
        return this.fullTypeName;
    }

    public String getFullTypeNameWithGenericType() {
        return this.fullTypeName;
    }

    public abstract TypeSchema copy();

    public TypeDto getDto() {
        TypeDto dto = new TypeDto();
        dto.fullTypeName = this.fullTypeName;
        dto.fullTypeNameWithGenericType = this.getFullTypeNameWithGenericType();
        dto.depth = this.depth;
        return dto;
    }

    public boolean sameType(TypeDto dto) {
        return this.fullTypeName.equals(dto.fullTypeName);
    }

    public Class<?> getClazz() {
        return this.originalType != null ? this.originalType : this.clazz;
    }

    public String getTypeNameForInstanceInJavaOrKotlin(boolean isJava) {
        return this.getFullTypeNameWithGenericType();
    }
}

