/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;

public class PrimitiveOrWrapperType
extends TypeSchema {
    public final boolean isWrapper;
    private static final List<Class<?>> INTEGRAL_NUMBER = Arrays.asList(Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE);
    private static final List<Class<?>> FLOATINGPOINT_NUMBER = Arrays.asList(Float.class, Float.TYPE, Double.class, Double.TYPE);
    private static final Map<Class, String> javaToKotlin = new HashMap<Class, String>(){
        {
            this.put(Byte.class, "Byte");
            this.put(Byte.TYPE, "Byte");
            this.put(Short.class, "Short");
            this.put(Short.TYPE, "Short");
            this.put(Integer.class, "Int");
            this.put(Integer.TYPE, "Int");
            this.put(Long.class, "Long");
            this.put(Long.TYPE, "Long");
            this.put(Float.class, "Float");
            this.put(Float.TYPE, "Float");
            this.put(Double.class, "Double");
            this.put(Double.TYPE, "Double");
            this.put(Boolean.class, "Boolean");
            this.put(Boolean.TYPE, "Boolean");
            this.put(Character.class, "Char");
            this.put(Character.TYPE, "Char");
        }
    };
    private static final List<String> types = Arrays.asList("int", "byte", "short", "long", "float", "double", "boolean", "char", "Integer", "Byte", "Short", "Long", "Float", "Double", "Boolean", "Character");

    public PrimitiveOrWrapperType(String type, String fullTypeName, boolean isWrapper, Class<?> clazz, JavaDtoSpec spec) {
        super(type, fullTypeName, clazz, spec);
        if (!PrimitiveOrWrapperType.isPrimitiveOrTypes(type)) {
            throw new IllegalStateException("the type is not Primitive Or Wrapper class: " + type);
        }
        this.isWrapper = isWrapper;
    }

    public PrimitiveOrWrapperType(String type, String fullTypeName, Class<?> clazz, JavaDtoSpec spec) {
        this(type, fullTypeName, types.indexOf(type) >= 8, clazz, spec);
    }

    public static boolean isPrimitiveOrTypes(String type) {
        return types.contains(type);
    }

    public static boolean isPrimitiveOrTypes(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return clazz == Integer.class || clazz == Byte.class || clazz == Short.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Boolean.class || clazz == Character.class;
    }

    @Override
    public PrimitiveOrWrapperType copy() {
        return new PrimitiveOrWrapperType(this.getSimpleTypeName(), this.getFullTypeName(), this.isWrapper, this.getClazz(), this.spec);
    }

    public boolean isNumber() {
        return this.isIntegralNumber() || this.isFloatingPointNumber();
    }

    public boolean isFloatingPointNumber() {
        return FLOATINGPOINT_NUMBER.contains(this.getClazz());
    }

    public boolean isIntegralNumber() {
        return INTEGRAL_NUMBER.contains(this.getClazz());
    }

    @Override
    public String getTypeNameForInstanceInJavaOrKotlin(boolean isJava) {
        if (!isJava) {
            return javaToKotlin.get(this.getClazz());
        }
        return this.getSimpleTypeName();
    }
}

